/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.groupbasedpolicy.sxp.mapper.impl.util;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.net.util.SubnetUtils;
import org.opendaylight.groupbasedpolicy.sxp.mapper.impl.util.SubnetInfoKeyDecorator;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groupbasedpolicy.common.rev140421.ConditionName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groupbasedpolicy.common.rev140421.EndpointGroupId;

public final class EPTemplateUtil {
    public static final String FULL_IPV4_MASK_SUFFIX = "/32";
    private static final Comparable EMPTY_COMPARABLE = "";

    private EPTemplateUtil() {
        throw new IllegalAccessError("constructing util class");
    }

    public static boolean isPlain(IpPrefix key) {
        return key.getIpv4Prefix().getValue().endsWith(FULL_IPV4_MASK_SUFFIX);
    }

    public static SubnetInfoKeyDecorator buildSubnetInfoKey(@Nonnull IpPrefix value) {
        return new SubnetInfoKeyDecorator(new SubnetUtils(value.getIpv4Prefix().getValue()).getInfo());
    }

    public static <L, R> ListenableFuture<OptionalMutablePair<L, R>> compositeRead(ListenableFuture<Optional<L>> leftRead, ListenableFuture<Optional<R>> rightRead) {
        final OptionalMutablePair compositeResult = new OptionalMutablePair();
        ArrayList<ListenableFuture> results = new ArrayList<ListenableFuture>(2);
        results.add(Futures.transform(leftRead, (Function)new Function<Optional<L>, OptionalMutablePair<L, R>>(){

            @Nullable
            public OptionalMutablePair<L, R> apply(@Nullable Optional<L> input) {
                compositeResult.setLeft(input);
                return compositeResult;
            }
        }));
        results.add(Futures.transform(rightRead, (Function)new Function<Optional<R>, OptionalMutablePair<L, R>>(){

            @Nullable
            public OptionalMutablePair<L, R> apply(@Nullable Optional<R> input) {
                compositeResult.setRight(input);
                return compositeResult;
            }
        }));
        return Futures.transform((ListenableFuture)Futures.successfulAsList(results), (Function)new Function<List<?>, OptionalMutablePair<L, R>>(){

            @Nullable
            public OptionalMutablePair<L, R> apply(@Nullable List<?> input) {
                return compositeResult;
            }
        });
    }

    public static <K, V> ListenableFuture<Pair<K, V>> wrapToPair(final K keyItem, ListenableFuture<Optional<V>> valueFromRead) {
        return Futures.transform(valueFromRead, (Function)new Function<Optional<V>, Pair<K, V>>(){

            @Nullable
            public Pair<K, V> apply(@Nullable Optional<V> input) {
                MutablePair pair = new MutablePair(keyItem, null);
                if (input != null && input.isPresent()) {
                    pair.setRight(input.get());
                }
                return pair;
            }
        });
    }

    public static <V> ListenableFuture<Optional<V>> wrapToOptional(ListenableFuture<V> value) {
        return Futures.transform(value, (Function)new Function<V, Optional<V>>(){

            @Nullable
            public Optional<V> apply(@Nullable V input) {
                return Optional.fromNullable(input);
            }
        });
    }

    public static Ordering<EndpointGroupId> createEndpointGroupIdOrdering() {
        return Ordering.natural().onResultOf((Function)new Function<EndpointGroupId, Comparable>(){

            @Nullable
            public Comparable apply(@Nullable EndpointGroupId input) {
                if (input == null) {
                    return EMPTY_COMPARABLE;
                }
                return (Comparable)MoreObjects.firstNonNull((Object)input.getValue(), (Object)EMPTY_COMPARABLE);
            }
        });
    }

    public static Ordering<ConditionName> createConditionNameOrdering() {
        return Ordering.natural().onResultOf((Function)new Function<ConditionName, Comparable>(){

            @Nullable
            public Comparable apply(@Nullable ConditionName input) {
                if (input == null) {
                    return EMPTY_COMPARABLE;
                }
                return (Comparable)MoreObjects.firstNonNull((Object)input.getValue(), (Object)EMPTY_COMPARABLE);
            }
        });
    }

    public static class OptionalMutablePair<L, R>
    extends MutablePair<Optional<L>, Optional<R>> {
        public OptionalMutablePair() {
            super((Object)Optional.absent(), (Object)Optional.absent());
        }
    }
}

