/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.groupbasedpolicy.sxp.mapper.impl.listen;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.Pair;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.DataTreeChangeListener;
import org.opendaylight.controller.md.sal.binding.api.DataTreeIdentifier;
import org.opendaylight.controller.md.sal.binding.api.DataTreeModification;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.groupbasedpolicy.sxp.mapper.api.DSAsyncDao;
import org.opendaylight.groupbasedpolicy.sxp.mapper.api.EPTemplateListener;
import org.opendaylight.groupbasedpolicy.sxp.mapper.api.ReadableAsyncByKey;
import org.opendaylight.groupbasedpolicy.sxp.mapper.api.SimpleCachedDao;
import org.opendaylight.groupbasedpolicy.sxp.mapper.api.SxpMapperReactor;
import org.opendaylight.groupbasedpolicy.sxp.mapper.impl.util.EPTemplateUtil;
import org.opendaylight.groupbasedpolicy.sxp.mapper.impl.util.L3EPServiceUtil;
import org.opendaylight.groupbasedpolicy.sxp.mapper.impl.util.SxpListenerUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.groupbasedpolicy.sxp.mapper.model.rev160302.sxp.mapper.EndpointForwardingTemplateBySubnet;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.groupbasedpolicy.sxp.mapper.model.rev160302.sxp.mapper.EndpointPolicyTemplateBySgt;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.groupbasedpolicy.sxp.mapper.model.rev160302.sxp.mapper.EndpointPolicyTemplateBySgtKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.database.rev160308.Sgt;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.database.rev160308.master.database.fields.MasterDatabaseBinding;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPolicyTemplateListenerImpl
implements EPTemplateListener<EndpointPolicyTemplateBySgt> {
    private static final Logger LOG = LoggerFactory.getLogger(EPPolicyTemplateListenerImpl.class);
    private static final FutureCallback<List<RpcResult<Void>>> RPC_RESULT_FUTURE_CALLBACK = L3EPServiceUtil.createFailureLoggingCallback("failed to apply epPolicyTemplate");
    private final ListenerRegistration<? extends EPTemplateListener> listenerRegistration;
    private final InstanceIdentifier<EndpointPolicyTemplateBySgt> templatePath;
    private final SxpMapperReactor sxpMapperReactor;
    private final SimpleCachedDao<Sgt, EndpointPolicyTemplateBySgt> templateCachedDao;
    private final ReadableAsyncByKey<Sgt, MasterDatabaseBinding> masterDBBindingDao;
    private final DSAsyncDao<IpPrefix, EndpointForwardingTemplateBySubnet> epForwardingTemplateDao;

    public EPPolicyTemplateListenerImpl(DataBroker dataBroker, SxpMapperReactor sxpMapperReactor, SimpleCachedDao<Sgt, EndpointPolicyTemplateBySgt> templateCachedDao, ReadableAsyncByKey<Sgt, MasterDatabaseBinding> masterDBBindingDao, DSAsyncDao<IpPrefix, EndpointForwardingTemplateBySubnet> epForwardingTemplateDao) {
        this.sxpMapperReactor = (SxpMapperReactor)Preconditions.checkNotNull((Object)sxpMapperReactor);
        this.templateCachedDao = (SimpleCachedDao)Preconditions.checkNotNull(templateCachedDao);
        this.masterDBBindingDao = (ReadableAsyncByKey)Preconditions.checkNotNull(masterDBBindingDao);
        this.epForwardingTemplateDao = (DSAsyncDao)Preconditions.checkNotNull(epForwardingTemplateDao);
        this.templatePath = EPTemplateListener.SXP_MAPPER_TEMPLATE_PARENT_PATH.child(EndpointPolicyTemplateBySgt.class);
        DataTreeIdentifier dataTreeIdentifier = new DataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, this.templatePath);
        this.listenerRegistration = dataBroker.registerDataTreeChangeListener(dataTreeIdentifier, (DataTreeChangeListener)this);
        LOG.debug("started listening to {}", this.templatePath);
    }

    public void onDataTreeChanged(@Nonnull Collection<DataTreeModification<EndpointPolicyTemplateBySgt>> collection) {
        for (DataTreeModification<EndpointPolicyTemplateBySgt> change : collection) {
            LOG.trace("received modification: {} -> {}", (Object)change.getRootPath(), (Object)change.getRootNode().getModificationType());
            InstanceIdentifier changePath = change.getRootPath().getRootIdentifier();
            Sgt changeKey = ((EndpointPolicyTemplateBySgtKey)changePath.firstKeyOf(EndpointPolicyTemplateBySgt.class)).getSgt();
            SxpListenerUtil.updateCachedDao(this.templateCachedDao, changeKey, change);
            EndpointPolicyTemplateBySgt epPolicyTemplate = (EndpointPolicyTemplateBySgt)change.getRootNode().getDataAfter();
            this.processWithEPTemplates(epPolicyTemplate);
        }
    }

    private void processWithEPTemplates(EndpointPolicyTemplateBySgt epPolicyTemplate) {
        ListenableFuture<Collection<MasterDatabaseBinding>> sxpMasterDbItemsRead = this.masterDBBindingDao.readBy(epPolicyTemplate.getSgt());
        ListenableFuture epForwardingTemplatesRead = Futures.transform(sxpMasterDbItemsRead, this.createReadAndPairTemplateToBindingFunction(epPolicyTemplate));
        ListenableFuture rpcResult = Futures.transform((ListenableFuture)epForwardingTemplatesRead, this.createProcessAllFunction(epPolicyTemplate));
        Futures.addCallback((ListenableFuture)rpcResult, RPC_RESULT_FUTURE_CALLBACK);
    }

    private AsyncFunction<List<Pair<MasterDatabaseBinding, EndpointForwardingTemplateBySubnet>>, List<RpcResult<Void>>> createProcessAllFunction(final EndpointPolicyTemplateBySgt epPolicyTemplate) {
        return new AsyncFunction<List<Pair<MasterDatabaseBinding, EndpointForwardingTemplateBySubnet>>, List<RpcResult<Void>>>(){

            public ListenableFuture<List<RpcResult<Void>>> apply(List<Pair<MasterDatabaseBinding, EndpointForwardingTemplateBySubnet>> input) throws Exception {
                ListenableFuture result;
                if (input == null || input.isEmpty()) {
                    LOG.debug("no epForwardingTemplate available for sgt: {}", (Object)epPolicyTemplate.getSgt());
                    result = Futures.immediateFuture(Collections.singletonList(RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "no epForwardingTemplate available for sgt " + epPolicyTemplate.getSgt()).build()));
                } else {
                    LOG.trace("processing epPolicyTemplate event for sgt: {}", (Object)epPolicyTemplate.getSgt());
                    ArrayList<ListenableFuture<RpcResult<Void>>> allResults = new ArrayList<ListenableFuture<RpcResult<Void>>>(input.size());
                    for (Pair<MasterDatabaseBinding, EndpointForwardingTemplateBySubnet> pair : input) {
                        MasterDatabaseBinding sxpMasterDBBinding = (MasterDatabaseBinding)pair.getLeft();
                        EndpointForwardingTemplateBySubnet epForwardingTemplate = (EndpointForwardingTemplateBySubnet)pair.getRight();
                        if (epForwardingTemplate == null) continue;
                        LOG.trace("processing epPolicyTemplate event with resolved sxpMasterDb entry and epForwardingTemplate for sgt/ip-prefix: {}/{}", (Object)sxpMasterDBBinding.getSecurityGroupTag(), (Object)sxpMasterDBBinding.getImplementedInterface());
                        allResults.add(EPPolicyTemplateListenerImpl.this.sxpMapperReactor.processTemplatesAndSxpMasterDB(epPolicyTemplate, epForwardingTemplate, sxpMasterDBBinding));
                    }
                    result = Futures.successfulAsList(allResults);
                }
                return result;
            }
        };
    }

    private AsyncFunction<Collection<MasterDatabaseBinding>, List<Pair<MasterDatabaseBinding, EndpointForwardingTemplateBySubnet>>> createReadAndPairTemplateToBindingFunction(final EndpointPolicyTemplateBySgt epPolicyTemplate) {
        return new AsyncFunction<Collection<MasterDatabaseBinding>, List<Pair<MasterDatabaseBinding, EndpointForwardingTemplateBySubnet>>>(){

            public ListenableFuture<List<Pair<MasterDatabaseBinding, EndpointForwardingTemplateBySubnet>>> apply(Collection<MasterDatabaseBinding> input) throws Exception {
                ListenableFuture result;
                if (input == null || input.isEmpty()) {
                    LOG.debug("no sxpMasterDB entry available for sgt: {}", (Object)epPolicyTemplate.getSgt());
                    result = Futures.immediateFuture(Collections.emptyList());
                } else {
                    LOG.trace("processing sxpMasterDB entries for sgt: {}", (Object)epPolicyTemplate.getSgt());
                    ArrayList allResults = new ArrayList(input.size());
                    for (MasterDatabaseBinding masterDBItem : input) {
                        ListenableFuture epForwardingTemplateRead = EPPolicyTemplateListenerImpl.this.epForwardingTemplateDao.read(masterDBItem.getIpPrefix());
                        allResults.add(EPTemplateUtil.wrapToPair(masterDBItem, epForwardingTemplateRead));
                    }
                    result = Futures.successfulAsList(allResults);
                }
                return result;
            }
        };
    }

    @Override
    public void close() throws Exception {
        LOG.debug("closing listener registration to {}", this.templatePath);
        this.listenerRegistration.close();
    }
}

