/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.groupbasedpolicy.sxp.mapper.impl.listen;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.Pair;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.DataTreeChangeListener;
import org.opendaylight.controller.md.sal.binding.api.DataTreeIdentifier;
import org.opendaylight.controller.md.sal.binding.api.DataTreeModification;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.groupbasedpolicy.sxp.mapper.api.DSAsyncDao;
import org.opendaylight.groupbasedpolicy.sxp.mapper.api.EPTemplateListener;
import org.opendaylight.groupbasedpolicy.sxp.mapper.api.SimpleCachedDao;
import org.opendaylight.groupbasedpolicy.sxp.mapper.api.SxpMapperReactor;
import org.opendaylight.groupbasedpolicy.sxp.mapper.impl.util.EPTemplateUtil;
import org.opendaylight.groupbasedpolicy.sxp.mapper.impl.util.L3EPServiceUtil;
import org.opendaylight.groupbasedpolicy.sxp.mapper.impl.util.SxpListenerUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.groupbasedpolicy.sxp.mapper.model.rev160302.sxp.mapper.EndpointForwardingTemplateBySubnet;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.groupbasedpolicy.sxp.mapper.model.rev160302.sxp.mapper.EndpointForwardingTemplateBySubnetKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.groupbasedpolicy.sxp.mapper.model.rev160302.sxp.mapper.EndpointPolicyTemplateBySgt;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.database.rev160308.Sgt;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.database.rev160308.master.database.fields.MasterDatabaseBinding;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPForwardingTemplateListenerImpl
implements EPTemplateListener<EndpointForwardingTemplateBySubnet> {
    private static final Logger LOG = LoggerFactory.getLogger(EPForwardingTemplateListenerImpl.class);
    public static final FutureCallback<RpcResult<Void>> ANY_RPC_FUTURE_CALLBACK = L3EPServiceUtil.createFailureLoggingCallback("failed to read epForwardingTemplate");
    private final SxpMapperReactor sxpMapperReactor;
    private final SimpleCachedDao<IpPrefix, EndpointForwardingTemplateBySubnet> templateCachedDao;
    private final DSAsyncDao<IpPrefix, MasterDatabaseBinding> masterDBBindingDao;
    private final ListenerRegistration<? extends EPTemplateListener> listenerRegistration;
    private final InstanceIdentifier<EndpointForwardingTemplateBySubnet> templatePath;
    private final DSAsyncDao<Sgt, EndpointPolicyTemplateBySgt> epPolicyTemplateDao;

    public EPForwardingTemplateListenerImpl(DataBroker dataBroker, SxpMapperReactor sxpMapperReactor, SimpleCachedDao<IpPrefix, EndpointForwardingTemplateBySubnet> templateCachedDao, DSAsyncDao<IpPrefix, MasterDatabaseBinding> masterDBBindingDao, DSAsyncDao<Sgt, EndpointPolicyTemplateBySgt> epPolicyTemplateDao) {
        this.sxpMapperReactor = (SxpMapperReactor)Preconditions.checkNotNull((Object)sxpMapperReactor);
        this.templateCachedDao = (SimpleCachedDao)Preconditions.checkNotNull(templateCachedDao);
        this.masterDBBindingDao = (DSAsyncDao)Preconditions.checkNotNull(masterDBBindingDao);
        this.epPolicyTemplateDao = (DSAsyncDao)Preconditions.checkNotNull(epPolicyTemplateDao);
        this.templatePath = EPTemplateListener.SXP_MAPPER_TEMPLATE_PARENT_PATH.child(EndpointForwardingTemplateBySubnet.class);
        DataTreeIdentifier dataTreeIdentifier = new DataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, this.templatePath);
        this.listenerRegistration = dataBroker.registerDataTreeChangeListener(dataTreeIdentifier, (DataTreeChangeListener)this);
        LOG.debug("started listening to {}", this.templatePath);
    }

    public void onDataTreeChanged(@Nonnull Collection<DataTreeModification<EndpointForwardingTemplateBySubnet>> collection) {
        for (DataTreeModification<EndpointForwardingTemplateBySubnet> change : collection) {
            LOG.trace("received modification: {} -> {}", (Object)change.getRootPath(), (Object)change.getRootNode().getModificationType());
            InstanceIdentifier changePath = change.getRootPath().getRootIdentifier();
            IpPrefix changeKey = ((EndpointForwardingTemplateBySubnetKey)changePath.firstKeyOf(EndpointForwardingTemplateBySubnet.class)).getIpPrefix();
            SxpListenerUtil.updateCachedDao(this.templateCachedDao, changeKey, change);
            EndpointForwardingTemplateBySubnet epForwardingTemplate = (EndpointForwardingTemplateBySubnet)change.getRootNode().getDataAfter();
            this.processWithEPTemplates(epForwardingTemplate);
        }
    }

    private void processWithEPTemplates(EndpointForwardingTemplateBySubnet epForwardingTemplate) {
        ListenableFuture<Optional<MasterDatabaseBinding>> sxpMasterDbItemRead = this.masterDBBindingDao.read(epForwardingTemplate.getIpPrefix());
        ListenableFuture searchResult = Futures.transform(sxpMasterDbItemRead, this.createReadAndPairTemplateToBindingFunction(epForwardingTemplate));
        ListenableFuture rpcResult = Futures.transform((ListenableFuture)searchResult, this.createProcessAllFunction(epForwardingTemplate));
        Futures.addCallback((ListenableFuture)rpcResult, ANY_RPC_FUTURE_CALLBACK);
    }

    private AsyncFunction<Optional<Pair<MasterDatabaseBinding, EndpointPolicyTemplateBySgt>>, RpcResult<Void>> createProcessAllFunction(final EndpointForwardingTemplateBySubnet epForwardingTemplate) {
        return new AsyncFunction<Optional<Pair<MasterDatabaseBinding, EndpointPolicyTemplateBySgt>>, RpcResult<Void>>(){

            public ListenableFuture<RpcResult<Void>> apply(Optional<Pair<MasterDatabaseBinding, EndpointPolicyTemplateBySgt>> input) throws Exception {
                ListenableFuture<RpcResult<Void>> result;
                if (input == null || !input.isPresent()) {
                    LOG.debug("no epPolicyTemplate available for ip-prefix: {}", (Object)epForwardingTemplate.getIpPrefix());
                    result = Futures.immediateFuture((Object)RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "no epForwardingTemplate available for ip-prefix " + epForwardingTemplate.getIpPrefix()).build());
                } else {
                    LOG.trace("processing epForwardingTemplate event for ip-prefix: {}", (Object)epForwardingTemplate.getIpPrefix());
                    Pair pair = (Pair)input.get();
                    MasterDatabaseBinding sxpMasterDBBinding = (MasterDatabaseBinding)pair.getLeft();
                    EndpointPolicyTemplateBySgt epPolicyTemplate = (EndpointPolicyTemplateBySgt)pair.getRight();
                    LOG.trace("processing epForwardingTemplate event with resolved sxpMasterDb entry and epPolicyTemplate for sgt/ip-prefix: {}/{}", (Object)sxpMasterDBBinding.getSecurityGroupTag(), (Object)sxpMasterDBBinding.getImplementedInterface());
                    result = EPForwardingTemplateListenerImpl.this.sxpMapperReactor.processTemplatesAndSxpMasterDB(epPolicyTemplate, epForwardingTemplate, sxpMasterDBBinding);
                }
                return result;
            }
        };
    }

    private AsyncFunction<Optional<MasterDatabaseBinding>, Optional<Pair<MasterDatabaseBinding, EndpointPolicyTemplateBySgt>>> createReadAndPairTemplateToBindingFunction(final EndpointForwardingTemplateBySubnet epFowardingTemplate) {
        return new AsyncFunction<Optional<MasterDatabaseBinding>, Optional<Pair<MasterDatabaseBinding, EndpointPolicyTemplateBySgt>>>(){

            public ListenableFuture<Optional<Pair<MasterDatabaseBinding, EndpointPolicyTemplateBySgt>>> apply(Optional<MasterDatabaseBinding> input) throws Exception {
                ListenableFuture result;
                if (input == null || !input.isPresent()) {
                    LOG.debug("no sxpMasterDB entry available for ip-prefix: {}", (Object)epFowardingTemplate.getIpPrefix());
                    result = Futures.immediateFuture(null);
                } else {
                    LOG.trace("processing sxpMasterDB entry for ip-prefix: {}", (Object)epFowardingTemplate.getIpPrefix());
                    MasterDatabaseBinding masterDBItem = (MasterDatabaseBinding)input.get();
                    ListenableFuture epPolicyTemplateRead = EPForwardingTemplateListenerImpl.this.epPolicyTemplateDao.read(masterDBItem.getSecurityGroupTag());
                    result = EPTemplateUtil.wrapToPair(masterDBItem, epPolicyTemplateRead);
                }
                return EPTemplateUtil.wrapToOptional(result);
            }
        };
    }

    @Override
    public void close() throws Exception {
        LOG.debug("closing listener registration to {}", this.templatePath);
        this.listenerRegistration.close();
    }
}

