/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.groupbasedpolicy.sxp.mapper.impl.dao;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.groupbasedpolicy.sxp.mapper.api.SimpleCachedDao;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SimpleCachedDaoImpl<K, V extends DataObject>
implements SimpleCachedDao<K, V> {
    private final ConcurrentMap<K, V> cache = new ConcurrentHashMap();

    @Override
    public V update(@Nonnull K key, @Nullable V value) {
        DataObject previousValue = value != null ? (DataObject)this.cache.put(key, value) : (DataObject)this.cache.remove(key);
        return (V)previousValue;
    }

    @Override
    public Optional<V> find(@Nonnull K key) {
        return Optional.fromNullable(this.cache.get(key));
    }

    @Override
    public void invalidateCache() {
        this.cache.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    @Override
    public Iterable<V> values() {
        return Iterables.unmodifiableIterable(this.cache.values());
    }
}

