/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.groupbasedpolicy.sxp.mapper.impl.dao;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.net.util.SubnetUtils;
import org.opendaylight.groupbasedpolicy.sxp.mapper.api.SimpleCachedDao;
import org.opendaylight.groupbasedpolicy.sxp.mapper.impl.util.EPTemplateUtil;
import org.opendaylight.groupbasedpolicy.sxp.mapper.impl.util.SubnetInfoKeyDecorator;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.groupbasedpolicy.sxp.mapper.model.rev160302.sxp.mapper.EndpointForwardingTemplateBySubnet;

public class SimpleCachedDaoEPForwardingTemplateImpl
implements SimpleCachedDao<IpPrefix, EndpointForwardingTemplateBySubnet> {
    private final ConcurrentMap<IpPrefix, EndpointForwardingTemplateBySubnet> plainCache;
    private final ConcurrentMap<SubnetInfoKeyDecorator, EndpointForwardingTemplateBySubnet> subnetCache;
    private final Pattern IP_MASK_EATER_RE = Pattern.compile("/[0-9]+");

    public SimpleCachedDaoEPForwardingTemplateImpl() {
        this.plainCache = new ConcurrentHashMap<IpPrefix, EndpointForwardingTemplateBySubnet>();
        this.subnetCache = new ConcurrentHashMap<SubnetInfoKeyDecorator, EndpointForwardingTemplateBySubnet>();
    }

    @Override
    public EndpointForwardingTemplateBySubnet update(@Nonnull IpPrefix key, @Nullable EndpointForwardingTemplateBySubnet value) {
        EndpointForwardingTemplateBySubnet previousValue = EPTemplateUtil.isPlain(key) ? this.updatePlainCache(key, value) : this.updateSubnetCache(key, value);
        return previousValue;
    }

    private EndpointForwardingTemplateBySubnet updateSubnetCache(IpPrefix key, EndpointForwardingTemplateBySubnet value) {
        SubnetInfoKeyDecorator subnetKey = EPTemplateUtil.buildSubnetInfoKey(key);
        EndpointForwardingTemplateBySubnet previousValue = value != null ? this.subnetCache.put(subnetKey, value) : (EndpointForwardingTemplateBySubnet)this.subnetCache.remove(subnetKey);
        return previousValue;
    }

    private EndpointForwardingTemplateBySubnet updatePlainCache(@Nonnull IpPrefix key, @Nullable EndpointForwardingTemplateBySubnet value) {
        EndpointForwardingTemplateBySubnet previousValue = value != null ? this.plainCache.put(key, value) : (EndpointForwardingTemplateBySubnet)this.plainCache.remove(key);
        return previousValue;
    }

    @Override
    public Optional<EndpointForwardingTemplateBySubnet> find(@Nonnull IpPrefix key) {
        SubnetInfoKeyDecorator keyDecorator;
        Optional fastSubnet;
        Optional fastPlain;
        Optional template = EPTemplateUtil.isPlain(key) ? ((fastPlain = Optional.fromNullable(this.plainCache.get(key))).isPresent() ? fastPlain : this.lookupSlowSubnet(key.getIpv4Prefix().getValue())) : ((fastSubnet = Optional.fromNullable(this.subnetCache.get(keyDecorator = EPTemplateUtil.buildSubnetInfoKey(key)))).isPresent() ? fastSubnet : Optional.absent());
        return template;
    }

    private Optional<EndpointForwardingTemplateBySubnet> lookupSlowSubnet(String value) {
        String plainIp = this.IP_MASK_EATER_RE.matcher(value).replaceFirst("");
        EndpointForwardingTemplateBySubnet valueCandidate = null;
        int addressCount = 0;
        for (Map.Entry entry : this.subnetCache.entrySet()) {
            SubnetUtils.SubnetInfo subnetInfo = ((SubnetInfoKeyDecorator)entry.getKey()).getDelegate();
            if (!subnetInfo.isInRange(plainIp)) continue;
            int addressCountTmp = subnetInfo.getAddressCount();
            if (valueCandidate != null && addressCount <= addressCountTmp) continue;
            valueCandidate = (EndpointForwardingTemplateBySubnet)entry.getValue();
            addressCount = addressCountTmp;
        }
        return Optional.fromNullable(valueCandidate);
    }

    @Override
    public void invalidateCache() {
        this.plainCache.clear();
        this.subnetCache.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.plainCache.isEmpty() && this.subnetCache.isEmpty();
    }

    @Override
    public Iterable<EndpointForwardingTemplateBySubnet> values() {
        return Iterables.unmodifiableIterable((Iterable)Iterables.concat(this.plainCache.values(), this.subnetCache.values()));
    }
}

