/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.groupbasedpolicy.sxp.mapper.impl.dao;

import com.google.common.collect.Ordering;
import java.util.Collections;
import java.util.List;
import org.opendaylight.groupbasedpolicy.sxp.mapper.impl.dao.EpPolicyTemplateValueKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groupbasedpolicy.common.rev140421.ConditionName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groupbasedpolicy.common.rev140421.EndpointGroupId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groupbasedpolicy.common.rev140421.TenantId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.groupbasedpolicy.sxp.mapper.model.rev160302.sxp.mapper.EndpointPolicyTemplateBySgt;

public class EpPolicyTemplateValueKeyFactory {
    private final Ordering<EndpointGroupId> epgIdOrdering;
    private final Ordering<ConditionName> conditionOrdering;

    public EpPolicyTemplateValueKeyFactory(Ordering<EndpointGroupId> epgIdOrdering, Ordering<ConditionName> conditionOrdering) {
        this.epgIdOrdering = epgIdOrdering;
        this.conditionOrdering = conditionOrdering;
    }

    public EndpointPolicyTemplateBySgt sortValueKeyLists(EndpointPolicyTemplateBySgt template) {
        if (template.getEndpointGroups() != null) {
            Collections.sort(template.getEndpointGroups(), this.epgIdOrdering);
        }
        if (template.getConditions() != null) {
            Collections.sort(template.getConditions(), this.conditionOrdering);
        }
        return template;
    }

    public EpPolicyTemplateValueKey createKeyWithDefaultOrdering(EndpointPolicyTemplateBySgt newSource) {
        return new EpPolicyTemplateValueKey(newSource.getTenant(), newSource.getEndpointGroups(), newSource.getConditions());
    }

    public EpPolicyTemplateValueKey sortValueKeyLists(EpPolicyTemplateValueKey existingKey) {
        Collections.sort(existingKey.getEpgId(), this.epgIdOrdering);
        if (existingKey.getConditionName() != null) {
            Collections.sort(existingKey.getConditionName(), this.conditionOrdering);
        }
        return existingKey;
    }

    public EpPolicyTemplateValueKey createKey(TenantId tenant, List<EndpointGroupId> endpointGroup, List<ConditionName> condition) {
        return this.sortValueKeyLists(new EpPolicyTemplateValueKey(tenant, endpointGroup, condition));
    }
}

