/*
 * Copyright (c) 2013 Cisco Systems, Inc. and others.  All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 */

package org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model;

import java.util.Date;

import org.opendaylight.controller.config.yangjmxgenerator.plugin.JMXGenerator;

public class HeaderSerializer {
    private static final String GENERATOR_CLASS = JMXGenerator.class.getCanonicalName();

    public static String toString(Header header) {
        return "Generated file" + "\n" +
                "\n" +
                "Generated from: " +
                "yang module name: " + header.getYangModuleName() +
                " yang module local name: " + header.getYangModuleLocalName() + "\n" +
                "Generated by: " + GENERATOR_CLASS + "\n" +
                "Generated at: " + new Date() + "\n" +
                "\n" +
                "Do not modify this file unless it is present under src/main directory ";
    }

}
