/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin.gofactory;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import java.util.LinkedHashMap;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.yangjmxgenerator.ModuleMXBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.java.FullyQualifiedName;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.java.GeneratedObject;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.java.GeneratedObjectBuilder;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.java.JavaFileInputBuilder;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.java.TypeName;

public class ConcreteModuleGeneratedObjectFactory {
    public GeneratedObject toGeneratedObject(ModuleMXBeanEntry mbe, Optional<String> copyright, Optional<String> header) {
        FullyQualifiedName concreteFQN = new FullyQualifiedName(mbe.getPackageName(), mbe.getStubModuleName());
        FullyQualifiedName abstractFQN = new FullyQualifiedName(mbe.getPackageName(), mbe.getAbstractModuleName());
        Optional classJavaDoc = Optional.fromNullable((Object)mbe.getNullableDescription());
        return this.toGeneratedObject(concreteFQN, abstractFQN, copyright, header, (Optional<String>)classJavaDoc);
    }

    GeneratedObject toGeneratedObject(FullyQualifiedName concreteFQN, FullyQualifiedName abstractFQN, Optional<String> copyright, Optional<String> header, Optional<String> classJavaDoc) {
        JavaFileInputBuilder builder = new JavaFileInputBuilder();
        builder.setTypeName(TypeName.classType);
        builder.setFqn(concreteFQN);
        builder.addExtendsFQN(abstractFQN);
        builder.setCopyright(copyright);
        builder.setHeader(header);
        builder.setClassJavaDoc(classJavaDoc);
        builder.addToBody(ConcreteModuleGeneratedObjectFactory.getNewCtor(concreteFQN));
        builder.addToBody(ConcreteModuleGeneratedObjectFactory.getCopyCtor(concreteFQN));
        builder.addToBody(ConcreteModuleGeneratedObjectFactory.getCustomValidationStub());
        builder.addToBody(ConcreteModuleGeneratedObjectFactory.getCreateInstanceStub());
        return new GeneratedObjectBuilder(builder.build()).toGeneratedObject();
    }

    private static String getNewCtor(FullyQualifiedName fqn) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put(ModuleIdentifier.class.getCanonicalName(), "identifier");
        parameters.put(DependencyResolver.class.getCanonicalName(), "dependencyResolver");
        StringBuilder stringBuilder = ConcreteModuleGeneratedObjectFactory.getCtor(fqn, parameters);
        return stringBuilder.toString();
    }

    private static StringBuilder getCtor(FullyQualifiedName fqn, LinkedHashMap<String, String> parameters) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("public ").append(fqn.getTypeName()).append("(");
        stringBuilder.append(Joiner.on((String)", ").withKeyValueSeparator(" ").join(parameters));
        stringBuilder.append(") {\n");
        if (!parameters.isEmpty()) {
            stringBuilder.append("super(");
            stringBuilder.append(Joiner.on((String)", ").join(parameters.values()));
            stringBuilder.append(");\n");
        }
        stringBuilder.append("}");
        return stringBuilder;
    }

    private static String getCopyCtor(FullyQualifiedName fqn) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put(ModuleIdentifier.class.getCanonicalName(), "identifier");
        parameters.put(DependencyResolver.class.getCanonicalName(), "dependencyResolver");
        parameters.put(fqn.toString(), "oldModule");
        parameters.put(AutoCloseable.class.getCanonicalName(), "oldInstance");
        StringBuilder stringBuilder = ConcreteModuleGeneratedObjectFactory.getCtor(fqn, parameters);
        return stringBuilder.toString();
    }

    private static String getCustomValidationStub() {
        return "@Override\npublic void customValidation() {\n// add custom validation form module attributes here.\n}";
    }

    private static String getCreateInstanceStub() {
        return "@Override\npublic " + AutoCloseable.class.getCanonicalName() + " createInstance() {\n// TODO:implement\nthrow new " + UnsupportedOperationException.class.getCanonicalName() + "();\n}";
    }
}

