/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin.module.concrete;

import com.google.common.base.Optional;
import java.io.File;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.opendaylight.controller.config.yangjmxgenerator.ModuleMXBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.gofactory.ConcreteModuleGeneratedObjectFactory;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.java.FullyQualifiedName;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.java.GeneratedObject;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.module.AbstractGeneratedObjectTest;

public class ConcreteModuleGeneratedObjectFactoryTest
extends AbstractGeneratedObjectTest {
    @Test
    public void test() throws Exception {
        FullyQualifiedName fqn = new FullyQualifiedName("foo.bar", "Baz");
        FullyQualifiedName abstractFQN = new FullyQualifiedName("foo.bar", "AbstractBaz");
        String nullableDescription = null;
        ModuleMXBeanEntry moduleMXBeanEntry = ConcreteModuleGeneratedObjectFactoryTest.mockModuleMXBeanEntry(fqn, abstractFQN, nullableDescription);
        Optional copyright = Optional.absent();
        Optional header = Optional.absent();
        GeneratedObject go = new ConcreteModuleGeneratedObjectFactory().toGeneratedObject(moduleMXBeanEntry, copyright, header);
        Map.Entry entry = (Map.Entry)go.persist(this.generatorOutputPath).get();
        File dstFile = (File)entry.getValue();
        Node c = this.parse(dstFile);
        Assert.assertEquals((Object)fqn.getPackageName(), (Object)((ASTCompilationUnit)c).getPackageDeclaration().getPackageNameImage());
        Assert.assertEquals((Object)fqn.getTypeName(), (Object)((ASTClassOrInterfaceDeclaration)c.getFirstDescendantOfType(ASTClassOrInterfaceDeclaration.class)).getImage());
        this.assertHasMethodNamed(c, "customValidation");
        this.assertHasMethodNamed(c, "createInstance");
    }

    static ModuleMXBeanEntry mockModuleMXBeanEntry(FullyQualifiedName fqn, FullyQualifiedName abstractFQN, String nullableDescription) {
        ModuleMXBeanEntry mock = (ModuleMXBeanEntry)Mockito.mock(ModuleMXBeanEntry.class);
        Assert.assertEquals((Object)fqn.getPackageName(), (Object)abstractFQN.getPackageName());
        ((ModuleMXBeanEntry)Mockito.doReturn((Object)fqn.getPackageName()).when((Object)mock)).getPackageName();
        ((ModuleMXBeanEntry)Mockito.doReturn((Object)fqn.getTypeName()).when((Object)mock)).getStubModuleName();
        ((ModuleMXBeanEntry)Mockito.doReturn((Object)nullableDescription).when((Object)mock)).getNullableDescription();
        ((ModuleMXBeanEntry)Mockito.doReturn((Object)abstractFQN.getTypeName()).when((Object)mock)).getAbstractModuleName();
        return mock;
    }
}

