/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.opendaylight.controller.config.yangjmxgenerator.ModuleMXBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.PackageTranslator;
import org.opendaylight.controller.config.yangjmxgenerator.ServiceInterfaceEntry;
import org.opendaylight.controller.config.yangjmxgenerator.TypeProviderWrapper;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.CodeWriter;
import org.opendaylight.yangtools.sal.binding.generator.spi.TypeProvider;
import org.opendaylight.yangtools.sal.binding.yang.types.TypeProviderImpl;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang2sources.spi.CodeGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;

public class JMXGenerator
implements CodeGenerator {
    static final String NAMESPACE_TO_PACKAGE_DIVIDER = "==";
    static final String NAMESPACE_TO_PACKAGE_PREFIX = "namespaceToPackage";
    static final String MODULE_FACTORY_FILE_BOOLEAN = "moduleFactoryFile";
    private PackageTranslator packageTranslator;
    private final CodeWriter codeWriter;
    private static final Logger logger = LoggerFactory.getLogger(JMXGenerator.class);
    private Map<String, String> namespaceToPackageMapping;
    private File resourceBaseDir;
    private File projectBaseDir;
    private boolean generateModuleFactoryFile = true;
    static Pattern namespaceMappingPattern = Pattern.compile("(.+)==(.+)");

    public JMXGenerator() {
        this.codeWriter = new CodeWriter();
    }

    public JMXGenerator(CodeWriter codeWriter) {
        this.codeWriter = codeWriter;
    }

    public Collection<File> generateSources(SchemaContext context, File outputBaseDir, Set<Module> yangModulesInCurrentMavenModule) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"Null context received");
        Preconditions.checkArgument((outputBaseDir != null ? 1 : 0) != 0, (Object)"Null outputBaseDir received");
        Preconditions.checkArgument((this.namespaceToPackageMapping != null && !this.namespaceToPackageMapping.isEmpty() ? 1 : 0) != 0, (Object)"No namespace to package mapping provided in additionalConfiguration");
        this.packageTranslator = new PackageTranslator(this.namespaceToPackageMapping);
        if (!outputBaseDir.exists()) {
            outputBaseDir.mkdirs();
        }
        GeneratedFilesTracker generatedFiles = new GeneratedFilesTracker();
        HashMap qNamesToSIEs = new HashMap();
        HashMap knownSEITracker = new HashMap();
        for (Module module : context.getModules()) {
            String packageName = this.packageTranslator.getPackageName(module);
            Map namesToSIEntries = ServiceInterfaceEntry.create((Module)module, (String)packageName, knownSEITracker);
            for (Map.Entry sieEntry : namesToSIEntries.entrySet()) {
                if (!qNamesToSIEs.containsKey(sieEntry.getKey())) {
                    qNamesToSIEs.put(sieEntry.getKey(), sieEntry.getValue());
                    continue;
                }
                throw new IllegalStateException("Cannot add two SIE  with same qname " + sieEntry.getValue());
            }
            if (!yangModulesInCurrentMavenModule.contains(module)) continue;
            for (ServiceInterfaceEntry sie : namesToSIEntries.values()) {
                try {
                    generatedFiles.addFile(this.codeWriter.writeSie(sie, outputBaseDir));
                }
                catch (Exception e) {
                    throw new RuntimeException("Error occurred during SIE source generate phase", e);
                }
            }
        }
        File mainBaseDir = JMXGenerator.concatFolders(this.projectBaseDir, "src", "main", "java");
        Preconditions.checkNotNull((Object)this.resourceBaseDir, (Object)"resource base dir attribute was null");
        StringBuffer fullyQualifiedNamesOfFactories = new StringBuffer();
        for (Module module : yangModulesInCurrentMavenModule) {
            String packageName = this.packageTranslator.getPackageName(module);
            Map namesToMBEs = ModuleMXBeanEntry.create((Module)module, qNamesToSIEs, (SchemaContext)context, (TypeProviderWrapper)new TypeProviderWrapper((TypeProvider)new TypeProviderImpl(context)), (String)packageName);
            for (Map.Entry mbeEntry : namesToMBEs.entrySet()) {
                ModuleMXBeanEntry mbe = (ModuleMXBeanEntry)mbeEntry.getValue();
                try {
                    List<File> files1 = this.codeWriter.writeMbe(mbe, outputBaseDir, mainBaseDir);
                    generatedFiles.addFile(files1);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error occurred during MBE source generate phase", e);
                }
                fullyQualifiedNamesOfFactories.append(mbe.getFullyQualifiedName(mbe.getStubFactoryName()));
                fullyQualifiedNamesOfFactories.append("\n");
            }
        }
        if (fullyQualifiedNamesOfFactories.length() > 0 && this.generateModuleFactoryFile) {
            File serviceLoaderFile = JMXGenerator.concatFolders(this.resourceBaseDir, "META-INF", "services", ModuleFactory.class.getName());
            serviceLoaderFile.getParentFile().mkdirs();
            try {
                serviceLoaderFile.createNewFile();
                FileUtils.write((File)serviceLoaderFile, (CharSequence)fullyQualifiedNamesOfFactories.toString());
            }
            catch (IOException e) {
                String message = "Cannot write to " + serviceLoaderFile;
                logger.error(message);
                throw new RuntimeException(message, e);
            }
        }
        return generatedFiles.getFiles();
    }

    static File concatFolders(File projectBaseDir, String ... folderNames) {
        StringBuilder b = new StringBuilder();
        for (String folder : folderNames) {
            b.append(folder);
            b.append(File.separator);
        }
        return new File(projectBaseDir, b.toString());
    }

    public void setAdditionalConfig(Map<String, String> additionalCfg) {
        if (logger != null) {
            logger.debug(this.getClass().getCanonicalName(), (Object)": Additional configuration received: ", (Object)additionalCfg.toString());
        }
        this.namespaceToPackageMapping = JMXGenerator.extractNamespaceMapping(additionalCfg);
        this.generateModuleFactoryFile = this.extractModuleFactoryBoolean(additionalCfg);
    }

    private boolean extractModuleFactoryBoolean(Map<String, String> additionalCfg) {
        String bool = additionalCfg.get(MODULE_FACTORY_FILE_BOOLEAN);
        if (bool == null) {
            return true;
        }
        return !bool.equals("false");
    }

    public void setLog(Log log) {
        StaticLoggerBinder.getSingleton().setMavenLog(log);
    }

    private static Map<String, String> extractNamespaceMapping(Map<String, String> additionalCfg) {
        HashMap namespaceToPackage = Maps.newHashMap();
        for (String key : additionalCfg.keySet()) {
            if (!key.startsWith(NAMESPACE_TO_PACKAGE_PREFIX)) continue;
            String mapping = additionalCfg.get(key);
            NamespaceMapping mappingResolved = JMXGenerator.extractNamespaceMapping(mapping);
            namespaceToPackage.put(mappingResolved.namespace, mappingResolved.packageName);
        }
        return namespaceToPackage;
    }

    private static NamespaceMapping extractNamespaceMapping(String mapping) {
        Matcher matcher = namespaceMappingPattern.matcher(mapping);
        Preconditions.checkArgument((boolean)matcher.matches(), (Object)String.format("Namespace to package mapping:%s is in invalid format, requested format is: %s", mapping, namespaceMappingPattern));
        return new NamespaceMapping(matcher.group(1), matcher.group(2));
    }

    public void setResourceBaseDir(File resourceDir) {
        this.resourceBaseDir = resourceDir;
    }

    public void setMavenProject(MavenProject project) {
        this.projectBaseDir = project.getBasedir();
        if (logger != null) {
            logger.debug(this.getClass().getCanonicalName(), (Object)" project base dir: ", (Object)this.projectBaseDir);
        }
    }

    @VisibleForTesting
    static class GeneratedFilesTracker {
        private final Set<File> files = Sets.newHashSet();

        GeneratedFilesTracker() {
        }

        void addFile(File file) {
            if (this.files.contains(file)) {
                ArrayList undeletedFiles = Lists.newArrayList();
                for (File presentFile : this.files) {
                    if (presentFile.delete()) continue;
                    undeletedFiles.add(presentFile);
                }
                if (!undeletedFiles.isEmpty()) {
                    logger.error("Illegal state occurred: Unable to delete already generated files, undeleted files: {}", (Object)undeletedFiles);
                }
                throw new IllegalStateException("Name conflict in generated files, file" + file + " present twice");
            }
            this.files.add(file);
        }

        void addFile(Collection<File> files) {
            for (File file : files) {
                this.addFile(file);
            }
        }

        public Set<File> getFiles() {
            return this.files;
        }
    }

    private static class NamespaceMapping {
        private final String namespace;
        private final String packageName;

        public NamespaceMapping(String namespace, String packagename) {
            this.namespace = namespace;
            this.packageName = packagename;
        }
    }
}

