/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opendaylight.controller.config.yangjmxgenerator.ModuleMXBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.RuntimeBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.ServiceInterfaceEntry;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.CodeWriter;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.FtlFilePersister;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.FtlTemplate;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.RuntimeRegistratorFtlTemplate;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.TemplateFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FreeMarkerCodeWriterImpl
implements CodeWriter {
    private static final Logger logger = LoggerFactory.getLogger(FreeMarkerCodeWriterImpl.class);
    private final FtlFilePersister ftlFilePersister = new FtlFilePersister();

    @Override
    public File writeSie(ServiceInterfaceEntry sie, File outputBaseDir) {
        try {
            Collection<FtlTemplate> values = TemplateFactory.getFtlTemplates(sie).values();
            return this.ftlFilePersister.persist(values, outputBaseDir, true).get(0);
        }
        catch (Exception e) {
            String message = "An error occurred during Service interface generating, sie:" + sie.getTypeName() + ", " + sie.getFullyQualifiedName();
            logger.error(message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
    }

    @Override
    public List<File> writeMbe(ModuleMXBeanEntry mbe, File targetBaseDir, File mainBaseDir, File resourceBaseDir) {
        try {
            ArrayList generatedFiles = Lists.newArrayList();
            generatedFiles.addAll(this.ftlFilePersister.persist(TemplateFactory.getFtlTemplates(mbe).values(), targetBaseDir, true));
            generatedFiles.addAll(this.ftlFilePersister.persist(TemplateFactory.getFtlStubTemplates(mbe).values(), mainBaseDir, false));
            Collection runtimeBeans = mbe.getRuntimeBeans();
            if (runtimeBeans.size() > 0) {
                ArrayList<FtlTemplate> allFtlFiles = new ArrayList<FtlTemplate>();
                Map<String, FtlTemplate> registratorNamesToFtls = RuntimeRegistratorFtlTemplate.create(RuntimeRegistratorFtlTemplate.findRoot(runtimeBeans));
                allFtlFiles.addAll(registratorNamesToFtls.values());
                for (RuntimeBeanEntry runtimeBeanEntry : runtimeBeans) {
                    Collection<FtlTemplate> ftlFiles = TemplateFactory.getTOAndMXInterfaceFtlFiles(runtimeBeanEntry).values();
                    allFtlFiles.addAll(ftlFiles);
                }
                boolean overwrite = true;
                FtlFilePersister ftlFilePersister = new FtlFilePersister();
                List<File> persisted = ftlFilePersister.persist(allFtlFiles, targetBaseDir, overwrite);
                generatedFiles.addAll(persisted);
            }
            Iterator it = generatedFiles.iterator();
            while (it.hasNext()) {
                if (it.next() != null) continue;
                it.remove();
            }
            return generatedFiles;
        }
        catch (Exception e) {
            String message = "An error occurred during Module generating, mbe:" + mbe.getJavaNamePrefix();
            logger.error(message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
    }
}

