/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.matchers.StringContains;
import org.opendaylight.controller.config.yangjmxgenerator.RuntimeBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.RuntimeRegistratorTest;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.FtlFilePersister;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.FtlTemplate;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.RuntimeRegistratorFtlTemplate;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.util.FormattingUtil;

public class RuntimeRegistratorFtlFileTest
extends RuntimeRegistratorTest {
    private final FtlFilePersister ftlFilePersister = new FtlFilePersister();

    @Test
    public void testRootWithoutAnything() {
        RuntimeBeanEntry rootRB = this.prepareRootRB(Collections.emptyList());
        Map createdFtls = RuntimeRegistratorFtlTemplate.create((RuntimeBeanEntry)rootRB);
        Assert.assertThat((Object)createdFtls.size(), (Matcher)CoreMatchers.is((Object)2));
        String rootRegistratorName = RuntimeRegistratorFtlTemplate.getJavaNameOfRuntimeRegistration((String)rootRB.getJavaNamePrefix());
        FtlTemplate rootFtlFile = (FtlTemplate)createdFtls.get(rootRegistratorName);
        Assert.assertNotNull((Object)rootFtlFile);
        Map serializedFtls = this.ftlFilePersister.serializeFtls(createdFtls.values());
        Assert.assertThat((Object)serializedFtls.size(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testHierarchy2() {
        RuntimeBeanEntry grandChildRB = this.prepareChildRB(Collections.emptyList(), "grand");
        RuntimeBeanEntry childRB = this.prepareChildRB(Arrays.asList(grandChildRB), "");
        RuntimeBeanEntry rootRB = this.prepareRootRB(Arrays.asList(childRB));
        Map createdFtls = RuntimeRegistratorFtlTemplate.create((RuntimeBeanEntry)rootRB);
        Map serializedFtls = this.ftlFilePersister.serializeFtls(createdFtls.values());
        Assert.assertThat((Object)serializedFtls.size(), (Matcher)CoreMatchers.is((Object)4));
        Assert.assertThat((Object)this.findRegistrationOutput(createdFtls, grandChildRB, serializedFtls), (Matcher)CoreMatchers.not((Matcher)StringContains.containsString((String)" register(")));
        FtlTemplate registrator = (FtlTemplate)createdFtls.get(RuntimeRegistratorFtlTemplate.getJavaNameOfRuntimeRegistrator((RuntimeBeanEntry)rootRB));
        FormattingUtil.cleanUpEmptyLinesAndIndent((String)serializedFtls.get(registrator));
    }

    private String findRegistrationOutput(Map<String, FtlTemplate> createdFtls, RuntimeBeanEntry rb, Map<FtlTemplate, String> serializedFtls) {
        RuntimeRegistratorFtlTemplate rbFtlFile = (RuntimeRegistratorFtlTemplate)createdFtls.get(RuntimeRegistratorFtlTemplate.getJavaNameOfRuntimeRegistration((String)rb.getJavaNamePrefix()));
        Assert.assertNotNull((Object)rbFtlFile);
        String unformatted = serializedFtls.get(rbFtlFile);
        Assert.assertNotNull((Object)unformatted);
        return FormattingUtil.cleanUpEmptyLinesAndIndent(unformatted);
    }
}

