/*
 * Copyright (c) 2013 Cisco Systems, Inc. and others.  All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.directives;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Map;

import org.opendaylight.controller.config.yangjmxgenerator.plugin.JMXGenerator;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.Header;

import com.google.common.base.Preconditions;

import freemarker.core.Environment;
import freemarker.ext.beans.StringModel;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;

/**
 * Add annotations to freemarker template.
 */
public class HeaderDirective implements TemplateDirectiveModel {

    private static final String GENERATOR_CLASS = JMXGenerator.class
            .getCanonicalName();
    private static final String OBJECT = "header";

    @Override
    public void execute(Environment env, Map params, TemplateModel[] loopVars,
            TemplateDirectiveBody body) throws TemplateException, IOException {

        // FIXME do not allow null header
        // Preconditions.checkNotNull(object, "Null type declaration");
        Object object = params.get(OBJECT);
        Header header = null;
        if (object != null) {
            object = ((StringModel) object).getWrappedObject();
            Preconditions.checkArgument(object instanceof Header,
                    "Template header should be instance of " + Header.class
                            + " but was " + object.getClass());

            header = (Header) object;
        }

        Writer out = env.getOut();
        StringBuilder build = new StringBuilder();
        build.append("/**");
        build.append(System.lineSeparator());
        build.append("* ");
        build.append("Generated file");
        build.append(System.lineSeparator());
        build.append(System.lineSeparator());
        build.append("* ");
        build.append("Generated from: ");
        build.append(header != null ? header.toString() : "");
        build.append(System.lineSeparator());
        build.append("* ");
        build.append("Generated by: " + GENERATOR_CLASS);
        build.append(System.lineSeparator());
        build.append("* ");
        build.append("Generated at: " + new Date());
        build.append(System.lineSeparator());
        build.append("* ");
        build.append(System.lineSeparator());
        build.append("* ");
        build.append("Do not modify this file unless it is present under src/main directory ");
        build.append(System.lineSeparator());
        build.append("*/");
        build.append(System.lineSeparator());

        out.write(build.toString().toCharArray());
    }
}
