/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.clustering.it.listener;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.WriteTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.people.rev140818.CarPeople;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.people.rev140818.car.people.CarPerson;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.people.rev140818.car.people.CarPersonBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.people.rev140818.car.people.CarPersonKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.purchase.rev140818.CarBought;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.purchase.rev140818.CarPurchaseListener;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeopleCarListener
implements CarPurchaseListener {
    private static final Logger LOG = LoggerFactory.getLogger(PeopleCarListener.class);
    private DataBroker dataProvider;

    public void setDataProvider(DataBroker salDataProvider) {
        this.dataProvider = salDataProvider;
    }

    public void onCarBought(CarBought notification) {
        CarPersonBuilder carPersonBuilder = new CarPersonBuilder();
        carPersonBuilder.setCarId(notification.getCarId());
        carPersonBuilder.setPersonId(notification.getPersonId());
        CarPersonKey key = new CarPersonKey(notification.getCarId(), notification.getPersonId());
        carPersonBuilder.withKey(key);
        final CarPerson carPerson = carPersonBuilder.build();
        LOG.info("Car bought, adding car-person entry: [{}]", (Object)carPerson);
        InstanceIdentifier carPersonIId = InstanceIdentifier.builder(CarPeople.class).child(CarPerson.class, (Identifier)carPerson.key()).build();
        WriteTransaction tx = this.dataProvider.newWriteOnlyTransaction();
        tx.put(LogicalDatastoreType.CONFIGURATION, carPersonIId, (DataObject)carPerson, true);
        Futures.addCallback((ListenableFuture)tx.submit(), (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(Void result) {
                LOG.info("Successfully added car-person entry: [{}]", (Object)carPerson);
            }

            public void onFailure(Throwable ex) {
                LOG.error("Failed to add car-person entry: [{}]", (Object)carPerson, (Object)ex);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }
}

