/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.modules.module.state;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.DateAndTime;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.DomBrokerOperational;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.modules.module.state.DomInmemoryDataBroker;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class DomInmemoryDataBrokerBuilder
implements Builder<DomInmemoryDataBroker> {
    private BigInteger _averageCommit;
    private BigInteger _longestCommitDuration;
    private DateAndTime _longestCommitTimestamp;
    private BigInteger _shortestCommitDuration;
    private DateAndTime _shortestCommitTimestamp;
    private BigInteger _totalCommits;
    Map<Class<? extends Augmentation<DomInmemoryDataBroker>>, Augmentation<DomInmemoryDataBroker>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKAVERAGECOMMITRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKLONGESTCOMMITDURATIONRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKSHORTESTCOMMITDURATIONRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKTOTALCOMMITSRANGE_RANGES;

    public DomInmemoryDataBrokerBuilder() {
    }

    public DomInmemoryDataBrokerBuilder(DomBrokerOperational arg) {
        this._totalCommits = arg.getTotalCommits();
        this._averageCommit = arg.getAverageCommit();
        this._longestCommitDuration = arg.getLongestCommitDuration();
        this._longestCommitTimestamp = arg.getLongestCommitTimestamp();
        this._shortestCommitDuration = arg.getShortestCommitDuration();
        this._shortestCommitTimestamp = arg.getShortestCommitTimestamp();
    }

    public DomInmemoryDataBrokerBuilder(DomInmemoryDataBroker base) {
        AugmentationHolder casted;
        this._averageCommit = base.getAverageCommit();
        this._longestCommitDuration = base.getLongestCommitDuration();
        this._longestCommitTimestamp = base.getLongestCommitTimestamp();
        this._shortestCommitDuration = base.getShortestCommitDuration();
        this._shortestCommitTimestamp = base.getShortestCommitTimestamp();
        this._totalCommits = base.getTotalCommits();
        if (base instanceof DomInmemoryDataBrokerImpl) {
            DomInmemoryDataBrokerImpl impl = (DomInmemoryDataBrokerImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<DomInmemoryDataBroker>>, Augmentation<DomInmemoryDataBroker>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<DomInmemoryDataBroker>>, Augmentation<DomInmemoryDataBroker>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof DomBrokerOperational) {
            this._totalCommits = ((DomBrokerOperational)arg).getTotalCommits();
            this._averageCommit = ((DomBrokerOperational)arg).getAverageCommit();
            this._longestCommitDuration = ((DomBrokerOperational)arg).getLongestCommitDuration();
            this._longestCommitTimestamp = ((DomBrokerOperational)arg).getLongestCommitTimestamp();
            this._shortestCommitDuration = ((DomBrokerOperational)arg).getShortestCommitDuration();
            this._shortestCommitTimestamp = ((DomBrokerOperational)arg).getShortestCommitTimestamp();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.DomBrokerOperational] \nbut was: " + arg);
        }
    }

    public BigInteger getAverageCommit() {
        return this._averageCommit;
    }

    public BigInteger getLongestCommitDuration() {
        return this._longestCommitDuration;
    }

    public DateAndTime getLongestCommitTimestamp() {
        return this._longestCommitTimestamp;
    }

    public BigInteger getShortestCommitDuration() {
        return this._shortestCommitDuration;
    }

    public DateAndTime getShortestCommitTimestamp() {
        return this._shortestCommitTimestamp;
    }

    public BigInteger getTotalCommits() {
        return this._totalCommits;
    }

    public <E extends Augmentation<DomInmemoryDataBroker>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkAverageCommitRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKAVERAGECOMMITRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKAVERAGECOMMITRANGE_RANGES)));
    }

    public DomInmemoryDataBrokerBuilder setAverageCommit(BigInteger value) {
        if (value != null) {
            DomInmemoryDataBrokerBuilder.checkAverageCommitRange(value);
        }
        this._averageCommit = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _averageCommit_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615")));
        return ret;
    }

    private static void checkLongestCommitDurationRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKLONGESTCOMMITDURATIONRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKLONGESTCOMMITDURATIONRANGE_RANGES)));
    }

    public DomInmemoryDataBrokerBuilder setLongestCommitDuration(BigInteger value) {
        if (value != null) {
            DomInmemoryDataBrokerBuilder.checkLongestCommitDurationRange(value);
        }
        this._longestCommitDuration = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _longestCommitDuration_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615")));
        return ret;
    }

    public DomInmemoryDataBrokerBuilder setLongestCommitTimestamp(DateAndTime value) {
        if (value != null) {
            // empty if block
        }
        this._longestCommitTimestamp = value;
        return this;
    }

    private static void checkShortestCommitDurationRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKSHORTESTCOMMITDURATIONRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKSHORTESTCOMMITDURATIONRANGE_RANGES)));
    }

    public DomInmemoryDataBrokerBuilder setShortestCommitDuration(BigInteger value) {
        if (value != null) {
            DomInmemoryDataBrokerBuilder.checkShortestCommitDurationRange(value);
        }
        this._shortestCommitDuration = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _shortestCommitDuration_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615")));
        return ret;
    }

    public DomInmemoryDataBrokerBuilder setShortestCommitTimestamp(DateAndTime value) {
        if (value != null) {
            // empty if block
        }
        this._shortestCommitTimestamp = value;
        return this;
    }

    private static void checkTotalCommitsRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKTOTALCOMMITSRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKTOTALCOMMITSRANGE_RANGES)));
    }

    public DomInmemoryDataBrokerBuilder setTotalCommits(BigInteger value) {
        if (value != null) {
            DomInmemoryDataBrokerBuilder.checkTotalCommitsRange(value);
        }
        this._totalCommits = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _totalCommits_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615")));
        return ret;
    }

    public DomInmemoryDataBrokerBuilder addAugmentation(Class<? extends Augmentation<DomInmemoryDataBroker>> augmentationType, Augmentation<DomInmemoryDataBroker> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<DomInmemoryDataBroker>>, Augmentation<DomInmemoryDataBroker>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public DomInmemoryDataBrokerBuilder removeAugmentation(Class<? extends Augmentation<DomInmemoryDataBroker>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public DomInmemoryDataBroker build() {
        return new DomInmemoryDataBrokerImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKAVERAGECOMMITRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKLONGESTCOMMITDURATIONRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKSHORTESTCOMMITDURATIONRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKTOTALCOMMITSRANGE_RANGES = a;
    }

    private static final class DomInmemoryDataBrokerImpl
    implements DomInmemoryDataBroker {
        private final BigInteger _averageCommit;
        private final BigInteger _longestCommitDuration;
        private final DateAndTime _longestCommitTimestamp;
        private final BigInteger _shortestCommitDuration;
        private final DateAndTime _shortestCommitTimestamp;
        private final BigInteger _totalCommits;
        private Map<Class<? extends Augmentation<DomInmemoryDataBroker>>, Augmentation<DomInmemoryDataBroker>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<DomInmemoryDataBroker> getImplementedInterface() {
            return DomInmemoryDataBroker.class;
        }

        private DomInmemoryDataBrokerImpl(DomInmemoryDataBrokerBuilder base) {
            this._averageCommit = base.getAverageCommit();
            this._longestCommitDuration = base.getLongestCommitDuration();
            this._longestCommitTimestamp = base.getLongestCommitTimestamp();
            this._shortestCommitDuration = base.getShortestCommitDuration();
            this._shortestCommitTimestamp = base.getShortestCommitTimestamp();
            this._totalCommits = base.getTotalCommits();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<DomInmemoryDataBroker>>, Augmentation<DomInmemoryDataBroker>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<DomInmemoryDataBroker>>, Augmentation<DomInmemoryDataBroker>>(base.augmentation);
                }
            }
        }

        @Override
        public BigInteger getAverageCommit() {
            return this._averageCommit;
        }

        @Override
        public BigInteger getLongestCommitDuration() {
            return this._longestCommitDuration;
        }

        @Override
        public DateAndTime getLongestCommitTimestamp() {
            return this._longestCommitTimestamp;
        }

        @Override
        public BigInteger getShortestCommitDuration() {
            return this._shortestCommitDuration;
        }

        @Override
        public DateAndTime getShortestCommitTimestamp() {
            return this._shortestCommitTimestamp;
        }

        @Override
        public BigInteger getTotalCommits() {
            return this._totalCommits;
        }

        public <E extends Augmentation<DomInmemoryDataBroker>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._averageCommit == null ? 0 : this._averageCommit.hashCode());
            result = 31 * result + (this._longestCommitDuration == null ? 0 : this._longestCommitDuration.hashCode());
            result = 31 * result + (this._longestCommitTimestamp == null ? 0 : this._longestCommitTimestamp.hashCode());
            result = 31 * result + (this._shortestCommitDuration == null ? 0 : this._shortestCommitDuration.hashCode());
            result = 31 * result + (this._shortestCommitTimestamp == null ? 0 : this._shortestCommitTimestamp.hashCode());
            result = 31 * result + (this._totalCommits == null ? 0 : this._totalCommits.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DomInmemoryDataBroker.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            DomInmemoryDataBroker other = (DomInmemoryDataBroker)obj;
            if (this._averageCommit == null ? other.getAverageCommit() != null : !this._averageCommit.equals(other.getAverageCommit())) {
                return false;
            }
            if (this._longestCommitDuration == null ? other.getLongestCommitDuration() != null : !this._longestCommitDuration.equals(other.getLongestCommitDuration())) {
                return false;
            }
            if (this._longestCommitTimestamp == null ? other.getLongestCommitTimestamp() != null : !this._longestCommitTimestamp.equals((Object)other.getLongestCommitTimestamp())) {
                return false;
            }
            if (this._shortestCommitDuration == null ? other.getShortestCommitDuration() != null : !this._shortestCommitDuration.equals(other.getShortestCommitDuration())) {
                return false;
            }
            if (this._shortestCommitTimestamp == null ? other.getShortestCommitTimestamp() != null : !this._shortestCommitTimestamp.equals((Object)other.getShortestCommitTimestamp())) {
                return false;
            }
            if (this._totalCommits == null ? other.getTotalCommits() != null : !this._totalCommits.equals(other.getTotalCommits())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                DomInmemoryDataBrokerImpl otherImpl = (DomInmemoryDataBrokerImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<DomInmemoryDataBroker>>, Augmentation<DomInmemoryDataBroker>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("DomInmemoryDataBroker [");
            boolean first = true;
            if (this._averageCommit != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_averageCommit=");
                builder.append(this._averageCommit);
            }
            if (this._longestCommitDuration != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_longestCommitDuration=");
                builder.append(this._longestCommitDuration);
            }
            if (this._longestCommitTimestamp != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_longestCommitTimestamp=");
                builder.append(this._longestCommitTimestamp);
            }
            if (this._shortestCommitDuration != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_shortestCommitDuration=");
                builder.append(this._shortestCommitDuration);
            }
            if (this._shortestCommitTimestamp != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_shortestCommitTimestamp=");
                builder.append(this._shortestCommitTimestamp);
            }
            if (this._totalCommits != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_totalCommits=");
                builder.append(this._totalCommits);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

