/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.modules.module.configuration;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.MaxQueueDepth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.modules.module.configuration.DomBrokerImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.modules.module.configuration.dom.broker.impl.AsyncDataBroker;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.modules.module.configuration.dom.broker.impl.RootSchemaService;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class DomBrokerImplBuilder
implements Builder<DomBrokerImpl> {
    private AsyncDataBroker _asyncDataBroker;
    private MaxQueueDepth _notificationQueueDepth;
    private Integer _notificationQueuePark;
    private Integer _notificationQueueSpin;
    private RootSchemaService _rootSchemaService;
    Map<Class<? extends Augmentation<DomBrokerImpl>>, Augmentation<DomBrokerImpl>> augmentation = Collections.emptyMap();

    public DomBrokerImplBuilder() {
    }

    public DomBrokerImplBuilder(DomBrokerImpl base) {
        AugmentationHolder casted;
        this._asyncDataBroker = base.getAsyncDataBroker();
        this._notificationQueueDepth = base.getNotificationQueueDepth();
        this._notificationQueuePark = base.getNotificationQueuePark();
        this._notificationQueueSpin = base.getNotificationQueueSpin();
        this._rootSchemaService = base.getRootSchemaService();
        if (base instanceof DomBrokerImplImpl) {
            DomBrokerImplImpl impl = (DomBrokerImplImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<DomBrokerImpl>>, Augmentation<DomBrokerImpl>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<DomBrokerImpl>>, Augmentation<DomBrokerImpl>>(casted.augmentations());
        }
    }

    public AsyncDataBroker getAsyncDataBroker() {
        return this._asyncDataBroker;
    }

    public MaxQueueDepth getNotificationQueueDepth() {
        return this._notificationQueueDepth;
    }

    public Integer getNotificationQueuePark() {
        return this._notificationQueuePark;
    }

    public Integer getNotificationQueueSpin() {
        return this._notificationQueueSpin;
    }

    public RootSchemaService getRootSchemaService() {
        return this._rootSchemaService;
    }

    public <E extends Augmentation<DomBrokerImpl>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public DomBrokerImplBuilder setAsyncDataBroker(AsyncDataBroker value) {
        this._asyncDataBroker = value;
        return this;
    }

    private static void checkNotificationQueueDepthRange(long value) {
        if (value >= 1L && value <= 0x40000000L) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[1\u20251073741824]].", value));
    }

    public DomBrokerImplBuilder setNotificationQueueDepth(MaxQueueDepth value) {
        if (value != null) {
            DomBrokerImplBuilder.checkNotificationQueueDepthRange(value.getValue());
        }
        this._notificationQueueDepth = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _notificationQueueDepth_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ONE, (Comparable)BigInteger.valueOf(0x40000000L)));
        return ret;
    }

    private static void checkNotificationQueueParkRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public DomBrokerImplBuilder setNotificationQueuePark(Integer value) {
        if (value != null) {
            DomBrokerImplBuilder.checkNotificationQueueParkRange(value);
        }
        this._notificationQueuePark = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _notificationQueuePark_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    private static void checkNotificationQueueSpinRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public DomBrokerImplBuilder setNotificationQueueSpin(Integer value) {
        if (value != null) {
            DomBrokerImplBuilder.checkNotificationQueueSpinRange(value);
        }
        this._notificationQueueSpin = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _notificationQueueSpin_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    public DomBrokerImplBuilder setRootSchemaService(RootSchemaService value) {
        this._rootSchemaService = value;
        return this;
    }

    public DomBrokerImplBuilder addAugmentation(Class<? extends Augmentation<DomBrokerImpl>> augmentationType, Augmentation<DomBrokerImpl> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<DomBrokerImpl>>, Augmentation<DomBrokerImpl>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public DomBrokerImplBuilder removeAugmentation(Class<? extends Augmentation<DomBrokerImpl>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public DomBrokerImpl build() {
        return new DomBrokerImplImpl(this);
    }

    private static final class DomBrokerImplImpl
    implements DomBrokerImpl {
        private final AsyncDataBroker _asyncDataBroker;
        private final MaxQueueDepth _notificationQueueDepth;
        private final Integer _notificationQueuePark;
        private final Integer _notificationQueueSpin;
        private final RootSchemaService _rootSchemaService;
        private Map<Class<? extends Augmentation<DomBrokerImpl>>, Augmentation<DomBrokerImpl>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<DomBrokerImpl> getImplementedInterface() {
            return DomBrokerImpl.class;
        }

        private DomBrokerImplImpl(DomBrokerImplBuilder base) {
            this._asyncDataBroker = base.getAsyncDataBroker();
            this._notificationQueueDepth = base.getNotificationQueueDepth();
            this._notificationQueuePark = base.getNotificationQueuePark();
            this._notificationQueueSpin = base.getNotificationQueueSpin();
            this._rootSchemaService = base.getRootSchemaService();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<DomBrokerImpl>>, Augmentation<DomBrokerImpl>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<DomBrokerImpl>>, Augmentation<DomBrokerImpl>>(base.augmentation);
                }
            }
        }

        @Override
        public AsyncDataBroker getAsyncDataBroker() {
            return this._asyncDataBroker;
        }

        @Override
        public MaxQueueDepth getNotificationQueueDepth() {
            return this._notificationQueueDepth;
        }

        @Override
        public Integer getNotificationQueuePark() {
            return this._notificationQueuePark;
        }

        @Override
        public Integer getNotificationQueueSpin() {
            return this._notificationQueueSpin;
        }

        @Override
        public RootSchemaService getRootSchemaService() {
            return this._rootSchemaService;
        }

        public <E extends Augmentation<DomBrokerImpl>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._asyncDataBroker == null ? 0 : this._asyncDataBroker.hashCode());
            result = 31 * result + (this._notificationQueueDepth == null ? 0 : this._notificationQueueDepth.hashCode());
            result = 31 * result + (this._notificationQueuePark == null ? 0 : this._notificationQueuePark.hashCode());
            result = 31 * result + (this._notificationQueueSpin == null ? 0 : this._notificationQueueSpin.hashCode());
            result = 31 * result + (this._rootSchemaService == null ? 0 : this._rootSchemaService.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DomBrokerImpl.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            DomBrokerImpl other = (DomBrokerImpl)obj;
            if (this._asyncDataBroker == null ? other.getAsyncDataBroker() != null : !this._asyncDataBroker.equals(other.getAsyncDataBroker())) {
                return false;
            }
            if (this._notificationQueueDepth == null ? other.getNotificationQueueDepth() != null : !this._notificationQueueDepth.equals(other.getNotificationQueueDepth())) {
                return false;
            }
            if (this._notificationQueuePark == null ? other.getNotificationQueuePark() != null : !this._notificationQueuePark.equals(other.getNotificationQueuePark())) {
                return false;
            }
            if (this._notificationQueueSpin == null ? other.getNotificationQueueSpin() != null : !this._notificationQueueSpin.equals(other.getNotificationQueueSpin())) {
                return false;
            }
            if (this._rootSchemaService == null ? other.getRootSchemaService() != null : !this._rootSchemaService.equals(other.getRootSchemaService())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                DomBrokerImplImpl otherImpl = (DomBrokerImplImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<DomBrokerImpl>>, Augmentation<DomBrokerImpl>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("DomBrokerImpl [");
            boolean first = true;
            if (this._asyncDataBroker != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_asyncDataBroker=");
                builder.append(this._asyncDataBroker);
            }
            if (this._notificationQueueDepth != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_notificationQueueDepth=");
                builder.append(this._notificationQueueDepth);
            }
            if (this._notificationQueuePark != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_notificationQueuePark=");
                builder.append(this._notificationQueuePark);
            }
            if (this._notificationQueueSpin != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_notificationQueueSpin=");
                builder.append(this._notificationQueueSpin);
            }
            if (this._rootSchemaService != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_rootSchemaService=");
                builder.append(this._rootSchemaService);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

