/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.dom.broker.util;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.ConstraintDefinition;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ExtensionDefinition;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleIdentifier;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextProvider;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.UsesNode;

public class ProxySchemaContext
implements SchemaContext {
    private final SchemaContextProvider schemaProvider;

    public ProxySchemaContext(SchemaContextProvider schemaProvider) {
        this.schemaProvider = schemaProvider;
    }

    private SchemaContext getCurrentSchema() {
        Preconditions.checkState((this.schemaProvider.getSchemaContext() != null ? 1 : 0) != 0, (String)"Schema context unavailable from %s", (Object[])new Object[]{this.schemaProvider});
        return this.schemaProvider.getSchemaContext();
    }

    public Set<DataSchemaNode> getDataDefinitions() {
        return this.getCurrentSchema().getDataDefinitions();
    }

    public Set<Module> getModules() {
        return this.getCurrentSchema().getModules();
    }

    public Set<NotificationDefinition> getNotifications() {
        return this.getCurrentSchema().getNotifications();
    }

    public Set<RpcDefinition> getOperations() {
        return this.getCurrentSchema().getOperations();
    }

    public Set<ExtensionDefinition> getExtensions() {
        return this.getCurrentSchema().getExtensions();
    }

    public Module findModuleByName(String s, Date date) {
        return this.getCurrentSchema().findModuleByName(s, date);
    }

    public Set<Module> findModuleByNamespace(URI uri) {
        return this.getCurrentSchema().findModuleByNamespace(uri);
    }

    public Module findModuleByNamespaceAndRevision(URI uri, Date date) {
        return this.getCurrentSchema().findModuleByNamespaceAndRevision(uri, date);
    }

    public Optional<String> getModuleSource(ModuleIdentifier moduleIdentifier) {
        return this.getCurrentSchema().getModuleSource(moduleIdentifier);
    }

    public Set<ModuleIdentifier> getAllModuleIdentifiers() {
        return this.getCurrentSchema().getAllModuleIdentifiers();
    }

    public boolean isPresenceContainer() {
        return this.getCurrentSchema().isPresenceContainer();
    }

    public Set<TypeDefinition<?>> getTypeDefinitions() {
        return this.getCurrentSchema().getTypeDefinitions();
    }

    public Collection<DataSchemaNode> getChildNodes() {
        return this.getCurrentSchema().getChildNodes();
    }

    public Set<GroupingDefinition> getGroupings() {
        return this.getCurrentSchema().getGroupings();
    }

    public DataSchemaNode getDataChildByName(QName qName) {
        return this.getCurrentSchema().getDataChildByName(qName);
    }

    public DataSchemaNode getDataChildByName(String s) {
        return this.getCurrentSchema().getDataChildByName(s);
    }

    public Set<UsesNode> getUses() {
        return this.getCurrentSchema().getUses();
    }

    public Set<AugmentationSchema> getAvailableAugmentations() {
        return this.getCurrentSchema().getAvailableAugmentations();
    }

    public boolean isAugmenting() {
        return this.getCurrentSchema().isAugmenting();
    }

    public boolean isAddedByUses() {
        return this.getCurrentSchema().isAddedByUses();
    }

    public boolean isConfiguration() {
        return this.getCurrentSchema().isConfiguration();
    }

    public ConstraintDefinition getConstraints() {
        return this.getCurrentSchema().getConstraints();
    }

    public QName getQName() {
        return this.getCurrentSchema().getQName();
    }

    public SchemaPath getPath() {
        return this.getCurrentSchema().getPath();
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.getCurrentSchema().getUnknownSchemaNodes();
    }

    public String getDescription() {
        return this.getCurrentSchema().getDescription();
    }

    public String getReference() {
        return this.getCurrentSchema().getReference();
    }

    public Status getStatus() {
        return this.getCurrentSchema().getStatus();
    }
}

