/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.broker.impl.mount;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.controller.md.sal.dom.api.DOMMountPoint;
import org.opendaylight.controller.md.sal.dom.api.DOMMountPointService;
import org.opendaylight.controller.md.sal.dom.api.DOMService;
import org.opendaylight.controller.md.sal.dom.broker.spi.mount.SimpleDOMMountPoint;
import org.opendaylight.controller.sal.core.api.mount.MountProvisionListener;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.util.ListenerRegistry;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public class DOMMountPointServiceImpl
implements DOMMountPointService {
    private final Map<YangInstanceIdentifier, DOMMountPoint> mountPoints = new HashMap<YangInstanceIdentifier, DOMMountPoint>();
    private final ListenerRegistry<MountProvisionListener> listeners = ListenerRegistry.create();

    public Optional<DOMMountPoint> getMountPoint(YangInstanceIdentifier path) {
        return Optional.fromNullable((Object)this.mountPoints.get(path));
    }

    public DOMMountPointService.DOMMountPointBuilder createMountPoint(YangInstanceIdentifier path) {
        Preconditions.checkState((!this.mountPoints.containsKey(path) ? 1 : 0) != 0, (Object)"Mount point already exists");
        return new DOMMountPointBuilderImpl(path);
    }

    public void notifyMountCreated(YangInstanceIdentifier identifier) {
        for (ListenerRegistration listener : this.listeners.getListeners()) {
            ((MountProvisionListener)listener.getInstance()).onMountPointCreated(identifier);
        }
    }

    public void notifyMountRemoved(YangInstanceIdentifier identifier) {
        for (ListenerRegistration listener : this.listeners.getListeners()) {
            ((MountProvisionListener)listener.getInstance()).onMountPointRemoved(identifier);
        }
    }

    public ListenerRegistration<MountProvisionListener> registerProvisionListener(MountProvisionListener listener) {
        return this.listeners.register((EventListener)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectRegistration<DOMMountPoint> registerMountPoint(DOMMountPoint mountPoint) {
        Map<YangInstanceIdentifier, DOMMountPoint> map = this.mountPoints;
        synchronized (map) {
            Preconditions.checkState((!this.mountPoints.containsKey(mountPoint.getIdentifier()) ? 1 : 0) != 0, (Object)"Mount point already exists");
            this.mountPoints.put((YangInstanceIdentifier)mountPoint.getIdentifier(), mountPoint);
        }
        this.notifyMountCreated((YangInstanceIdentifier)mountPoint.getIdentifier());
        return new MountRegistration(mountPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMountPoint(YangInstanceIdentifier mountPointId) {
        Map<YangInstanceIdentifier, DOMMountPoint> map = this.mountPoints;
        synchronized (map) {
            Preconditions.checkState((boolean)this.mountPoints.containsKey(mountPointId), (Object)"Mount point does not exist");
            this.mountPoints.remove(mountPointId);
        }
        this.notifyMountRemoved(mountPointId);
    }

    private final class MountRegistration
    implements ObjectRegistration<DOMMountPoint> {
        private final DOMMountPoint mountPoint;

        public MountRegistration(DOMMountPoint mountPoint) {
            this.mountPoint = mountPoint;
        }

        public DOMMountPoint getInstance() {
            return this.mountPoint;
        }

        public void close() throws Exception {
            DOMMountPointServiceImpl.this.unregisterMountPoint((YangInstanceIdentifier)this.mountPoint.getIdentifier());
        }
    }

    public class DOMMountPointBuilderImpl
    implements DOMMountPointService.DOMMountPointBuilder {
        ClassToInstanceMap<DOMService> services = MutableClassToInstanceMap.create();
        private SimpleDOMMountPoint mountPoint;
        private final YangInstanceIdentifier path;
        private SchemaContext schemaContext;

        public DOMMountPointBuilderImpl(YangInstanceIdentifier path) {
            this.path = path;
        }

        public <T extends DOMService> DOMMountPointService.DOMMountPointBuilder addService(Class<T> type, T impl) {
            this.services.putInstance(type, impl);
            return this;
        }

        public DOMMountPointService.DOMMountPointBuilder addInitialSchemaContext(SchemaContext ctx) {
            this.schemaContext = ctx;
            return this;
        }

        public ObjectRegistration<DOMMountPoint> register() {
            Preconditions.checkState((this.mountPoint == null ? 1 : 0) != 0, (Object)"Mount point is already built.");
            this.mountPoint = SimpleDOMMountPoint.create((YangInstanceIdentifier)this.path, this.services, (SchemaContext)this.schemaContext);
            return DOMMountPointServiceImpl.this.registerMountPoint((DOMMountPoint)this.mountPoint);
        }
    }
}

