/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.broker.impl;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.opendaylight.controller.md.sal.dom.broker.impl.ShardRegistration;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ShardingTableEntry
implements Identifiable<YangInstanceIdentifier.PathArgument> {
    private static final Logger LOG = LoggerFactory.getLogger(ShardingTableEntry.class);
    private final Map<YangInstanceIdentifier.PathArgument, ShardingTableEntry> children = Collections.emptyMap();
    private final YangInstanceIdentifier.PathArgument identifier;
    private ShardRegistration<?> registration;

    ShardingTableEntry() {
        this.identifier = null;
    }

    ShardingTableEntry(YangInstanceIdentifier.PathArgument identifier) {
        this.identifier = (YangInstanceIdentifier.PathArgument)Preconditions.checkNotNull((Object)identifier);
    }

    public YangInstanceIdentifier.PathArgument getIdentifier() {
        return this.identifier;
    }

    public ShardRegistration<?> getRegistration() {
        return this.registration;
    }

    ShardingTableEntry lookup(YangInstanceIdentifier id) {
        Iterator it = id.getPathArguments().iterator();
        ShardingTableEntry entry = this;
        while (it.hasNext()) {
            YangInstanceIdentifier.PathArgument a = (YangInstanceIdentifier.PathArgument)it.next();
            ShardingTableEntry child = entry.children.get(a);
            if (child == null) {
                LOG.debug("Lookup of {} stopped at {}", (Object)id, (Object)a);
                break;
            }
            entry = child;
        }
        return entry;
    }

    void store(YangInstanceIdentifier id, ShardRegistration<?> reg) {
        Iterator it = id.getPathArguments().iterator();
        ShardingTableEntry entry = this;
        while (it.hasNext()) {
            YangInstanceIdentifier.PathArgument a = (YangInstanceIdentifier.PathArgument)it.next();
            ShardingTableEntry child = entry.children.get(a);
            if (child != null) continue;
            child = new ShardingTableEntry(a);
            entry.children.put(a, child);
        }
        Preconditions.checkState((entry.registration == null ? 1 : 0) != 0);
        entry.registration = reg;
    }

    private boolean remove(Iterator<YangInstanceIdentifier.PathArgument> it) {
        if (it.hasNext()) {
            YangInstanceIdentifier.PathArgument arg = it.next();
            ShardingTableEntry child = this.children.get(arg);
            if (child != null) {
                if (child.remove(it)) {
                    this.children.remove(arg);
                }
            } else {
                LOG.warn("Cannot remove non-existent child {}", (Object)arg);
            }
        }
        return this.registration == null && this.children.isEmpty();
    }

    void remove(YangInstanceIdentifier id) {
        this.remove(id.getPathArguments().iterator());
    }
}

