/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.broker.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;
import org.opendaylight.controller.md.sal.common.api.TransactionStatus;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.TransactionCommitFailedException;
import org.opendaylight.controller.md.sal.common.impl.service.AbstractDataTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.controller.md.sal.dom.api.DOMDataWriteTransaction;
import org.opendaylight.controller.md.sal.dom.broker.impl.CommitCoordinationTask;
import org.opendaylight.controller.md.sal.dom.broker.impl.ShardedDOMDataTreeProducer;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreWriteTransaction;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
final class ShardedDOMDataWriteTransaction
implements DOMDataWriteTransaction {
    private static final Logger LOG = LoggerFactory.getLogger(ShardedDOMDataWriteTransaction.class);
    private static final AtomicLong COUNTER = new AtomicLong();
    private final Map<DOMDataTreeIdentifier, DOMStoreWriteTransaction> idToTransaction;
    private final ShardedDOMDataTreeProducer producer;
    private final String identifier;
    @GuardedBy(value="this")
    private boolean closed = false;

    ShardedDOMDataWriteTransaction(ShardedDOMDataTreeProducer producer, Map<DOMDataTreeIdentifier, DOMStoreWriteTransaction> idToTransaction) {
        this.producer = (ShardedDOMDataTreeProducer)Preconditions.checkNotNull((Object)producer);
        this.idToTransaction = (Map)Preconditions.checkNotNull(idToTransaction);
        this.identifier = "SHARDED-DOM-" + COUNTER.getAndIncrement();
    }

    @GuardedBy(value="this")
    private DOMStoreWriteTransaction lookup(LogicalDatastoreType store, YangInstanceIdentifier path) {
        DOMDataTreeIdentifier id = new DOMDataTreeIdentifier(store, path);
        for (Map.Entry<DOMDataTreeIdentifier, DOMStoreWriteTransaction> e : this.idToTransaction.entrySet()) {
            if (!e.getKey().contains(id)) continue;
            return e.getValue();
        }
        throw new IllegalArgumentException(String.format("Path %s is not acessible from transaction %s", id, this));
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public synchronized boolean cancel() {
        if (this.closed) {
            return false;
        }
        LOG.debug("Cancelling transaction {}", (Object)this.identifier);
        for (DOMStoreWriteTransaction tx : ImmutableSet.copyOf(this.idToTransaction.values())) {
            tx.close();
        }
        this.closed = true;
        this.producer.cancelTransaction(this);
        return true;
    }

    public synchronized CheckedFuture<Void, TransactionCommitFailedException> submit() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (String)"Transaction %s is already closed", (Object[])new Object[]{this.identifier});
        ImmutableSet txns = ImmutableSet.copyOf(this.idToTransaction.values());
        ArrayList<DOMStoreThreePhaseCommitCohort> cohorts = new ArrayList<DOMStoreThreePhaseCommitCohort>(txns.size());
        for (DOMStoreWriteTransaction tx : txns) {
            cohorts.add(tx.ready());
        }
        try {
            return Futures.immediateCheckedFuture((Object)new CommitCoordinationTask(this, cohorts, null).call());
        }
        catch (TransactionCommitFailedException e) {
            return Futures.immediateFailedCheckedFuture((Exception)((Object)e));
        }
    }

    @Deprecated
    public ListenableFuture<RpcResult<TransactionStatus>> commit() {
        return AbstractDataTransaction.convertToLegacyCommitFuture(this.submit());
    }

    public synchronized void delete(LogicalDatastoreType store, YangInstanceIdentifier path) {
        this.lookup(store, path).delete(path);
    }

    public synchronized void put(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        this.lookup(store, path).write(path, data);
    }

    public synchronized void merge(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        this.lookup(store, path).merge(path, data);
    }
}

