/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.broker.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeProducer;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeProducerBusyException;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeProducerException;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeShard;
import org.opendaylight.controller.md.sal.dom.api.DOMDataWriteTransaction;
import org.opendaylight.controller.md.sal.dom.broker.impl.ShardedDOMDataTree;
import org.opendaylight.controller.md.sal.dom.broker.impl.ShardedDOMDataWriteTransaction;
import org.opendaylight.controller.sal.core.spi.data.DOMStore;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreTransactionChain;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreWriteTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ShardedDOMDataTreeProducer
implements DOMDataTreeProducer {
    private static final Logger LOG = LoggerFactory.getLogger(ShardedDOMDataTreeProducer.class);
    private final BiMap<DOMDataTreeShard, DOMStoreTransactionChain> shardToChain;
    private final Map<DOMDataTreeIdentifier, DOMDataTreeShard> idToShard;
    private final ShardedDOMDataTree dataTree;
    @GuardedBy(value="this")
    private Map<DOMDataTreeIdentifier, DOMDataTreeProducer> children = Collections.emptyMap();
    @GuardedBy(value="this")
    private DOMDataWriteTransaction openTx;
    @GuardedBy(value="this")
    private boolean closed;

    ShardedDOMDataTreeProducer(ShardedDOMDataTree dataTree, Map<DOMDataTreeIdentifier, DOMDataTreeShard> shardMap, Set<DOMDataTreeShard> shards) {
        this.dataTree = (ShardedDOMDataTree)Preconditions.checkNotNull((Object)dataTree);
        ImmutableBiMap.Builder cb = ImmutableBiMap.builder();
        LinkedList<Exception> es = new LinkedList<Exception>();
        for (DOMDataTreeShard s : shards) {
            if (s instanceof DOMStore) {
                try {
                    DOMStoreTransactionChain c = ((DOMStore)s).createTransactionChain();
                    LOG.trace("Using DOMStore chain {} to access shard {}", (Object)c, (Object)s);
                    cb.put((Object)s, (Object)c);
                }
                catch (Exception e) {
                    LOG.error("Failed to instantiate chain for shard {}", (Object)s, (Object)e);
                    es.add(e);
                }
                continue;
            }
            LOG.error("Unhandled shard instance type {}", s.getClass());
        }
        this.shardToChain = cb.build();
        if (this.shardToChain.size() != shards.size()) {
            for (DOMStoreTransactionChain c : this.shardToChain.values()) {
                try {
                    c.close();
                }
                catch (Exception e) {
                    LOG.warn("Exception raised while closing chain %s", (Object)c, (Object)e);
                }
            }
            IllegalStateException e = new IllegalStateException("Failed to completely allocate contexts", (Throwable)es.poll());
            while (!es.isEmpty()) {
                e.addSuppressed((Throwable)es.poll());
            }
            throw e;
        }
        this.idToShard = ImmutableMap.copyOf(shardMap);
    }

    public synchronized DOMDataWriteTransaction createTransaction(boolean isolated) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Producer is already closed");
        Preconditions.checkState((this.openTx == null ? 1 : 0) != 0, (String)"Transaction %s is still open", (Object[])new Object[]{this.openTx});
        HashMap shardToTx = new HashMap();
        for (Map.Entry e : this.shardToChain.entrySet()) {
            shardToTx.put(e.getKey(), ((DOMStoreTransactionChain)e.getValue()).newWriteOnlyTransaction());
        }
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (Map.Entry<DOMDataTreeIdentifier, DOMDataTreeShard> e : this.idToShard.entrySet()) {
            b.put((Object)e.getKey(), shardToTx.get(e.getValue()));
        }
        ShardedDOMDataWriteTransaction ret = new ShardedDOMDataWriteTransaction(this, (Map<DOMDataTreeIdentifier, DOMStoreWriteTransaction>)b.build());
        this.openTx = ret;
        return ret;
    }

    @GuardedBy(value="this")
    private boolean haveSubtree(DOMDataTreeIdentifier subtree) {
        for (DOMDataTreeIdentifier i : this.idToShard.keySet()) {
            if (!i.contains(subtree)) continue;
            return true;
        }
        return false;
    }

    @GuardedBy(value="this")
    private DOMDataTreeProducer lookupChild(DOMDataTreeIdentifier s) {
        for (Map.Entry<DOMDataTreeIdentifier, DOMDataTreeProducer> e : this.children.entrySet()) {
            if (!e.getKey().contains(s)) continue;
            return e.getValue();
        }
        return null;
    }

    public synchronized DOMDataTreeProducer createProducer(Collection<DOMDataTreeIdentifier> subtrees) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Producer is already closed");
        Preconditions.checkState((this.openTx == null ? 1 : 0) != 0, (String)"Transaction %s is still open", (Object[])new Object[]{this.openTx});
        for (DOMDataTreeIdentifier s : subtrees) {
            if (!this.haveSubtree(s)) {
                throw new IllegalArgumentException(String.format("Subtree %s was never available in producer %s", s, this));
            }
            DOMDataTreeProducer child = this.lookupChild(s);
            Preconditions.checkArgument((child == null ? 1 : 0) != 0, (String)"Subtree %s is delegated to child producer %s", (Object[])new Object[]{s, child});
            for (DOMDataTreeIdentifier c : this.children.keySet()) {
                if (!s.contains(c)) continue;
                throw new IllegalArgumentException(String.format("Subtree %s cannot be delegated as it is superset of already-delegated %s", s, c));
            }
        }
        DOMDataTreeProducer ret = this.dataTree.createProducer(this, subtrees);
        ImmutableMap.Builder cb = ImmutableMap.builder();
        cb.putAll(this.children);
        for (DOMDataTreeIdentifier s : subtrees) {
            cb.put((Object)s, (Object)ret);
        }
        this.children = cb.build();
        return ret;
    }

    public synchronized void close() throws DOMDataTreeProducerException {
        if (!this.closed) {
            if (this.openTx != null) {
                throw new DOMDataTreeProducerBusyException(String.format("Transaction %s is still open", this.openTx));
            }
            this.closed = true;
            this.dataTree.destroyProducer(this);
        }
    }

    static DOMDataTreeProducer create(ShardedDOMDataTree dataTree, Map<DOMDataTreeIdentifier, DOMDataTreeShard> shardMap) {
        ImmutableSet shards = ImmutableSet.copyOf(shardMap.values());
        if (shards.size() > 1) {
            throw new UnsupportedOperationException("Cross-shard producers are not supported yet");
        }
        return new ShardedDOMDataTreeProducer(dataTree, shardMap, (Set<DOMDataTreeShard>)shards);
    }

    Set<DOMDataTreeIdentifier> getSubtrees() {
        return this.idToShard.keySet();
    }

    synchronized void cancelTransaction(ShardedDOMDataWriteTransaction transaction) {
        if (!this.openTx.equals(transaction)) {
            LOG.warn("Transaction {} is not open in producer {}", (Object)transaction, (Object)this);
            return;
        }
        LOG.debug("Transaction {} cancelled", (Object)transaction);
        this.openTx = null;
    }
}

