/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.broker.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import java.util.List;
import java.util.Map;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcException;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcIdentifier;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcImplementation;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcImplementationNotAvailableException;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcResult;
import org.opendaylight.controller.md.sal.dom.broker.impl.AbstractDOMRpcRoutingTableEntry;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RoutedDOMRpcRoutingTableEntry
extends AbstractDOMRpcRoutingTableEntry {
    private static final Logger LOG = LoggerFactory.getLogger(RoutedDOMRpcRoutingTableEntry.class);
    private final DOMRpcIdentifier globalRpcId;
    private final YangInstanceIdentifier keyId;

    private RoutedDOMRpcRoutingTableEntry(DOMRpcIdentifier globalRpcId, YangInstanceIdentifier keyId, Map<YangInstanceIdentifier, List<DOMRpcImplementation>> impls) {
        super(globalRpcId.getType(), impls);
        this.keyId = (YangInstanceIdentifier)Preconditions.checkNotNull((Object)keyId);
        this.globalRpcId = (DOMRpcIdentifier)Preconditions.checkNotNull((Object)globalRpcId);
    }

    RoutedDOMRpcRoutingTableEntry(RpcDefinition def, YangInstanceIdentifier keyId, Map<YangInstanceIdentifier, List<DOMRpcImplementation>> impls) {
        super(def.getPath(), impls);
        this.keyId = (YangInstanceIdentifier)Preconditions.checkNotNull((Object)keyId);
        this.globalRpcId = DOMRpcIdentifier.create((SchemaPath)def.getPath());
    }

    @Override
    protected CheckedFuture<DOMRpcResult, DOMRpcException> invokeRpc(NormalizedNode<?, ?> input) {
        List<DOMRpcImplementation> impls;
        Optional maybeKey = NormalizedNodes.findNode(input, (YangInstanceIdentifier)this.keyId);
        if (maybeKey.isPresent()) {
            NormalizedNode key = (NormalizedNode)maybeKey.get();
            Object value = key.getValue();
            if (value instanceof YangInstanceIdentifier) {
                YangInstanceIdentifier iid = (YangInstanceIdentifier)value;
                List<DOMRpcImplementation> specificImpls = this.getImplementations(iid);
                if (specificImpls != null) {
                    return specificImpls.get(0).invokeRpc(DOMRpcIdentifier.create((SchemaPath)this.getSchemaPath(), (YangInstanceIdentifier)iid), input);
                }
                LOG.debug("No implementation for context {} found will now look for wildcard id", (Object)iid);
                List<DOMRpcImplementation> mayBeRemoteImpls = this.getImplementations(YangInstanceIdentifier.EMPTY);
                if (mayBeRemoteImpls != null) {
                    return mayBeRemoteImpls.get(0).invokeRpc(DOMRpcIdentifier.create((SchemaPath)this.getSchemaPath(), (YangInstanceIdentifier)iid), input);
                }
            } else {
                LOG.warn("Ignoring wrong context value {}", value);
            }
        }
        if ((impls = this.getImplementations(null)) != null) {
            return impls.get(0).invokeRpc(this.globalRpcId, input);
        }
        return Futures.immediateFailedCheckedFuture((Exception)new DOMRpcImplementationNotAvailableException("No implementation of RPC %s available", new Object[]{this.getSchemaPath()}));
    }

    @Override
    protected RoutedDOMRpcRoutingTableEntry newInstance(Map<YangInstanceIdentifier, List<DOMRpcImplementation>> impls) {
        return new RoutedDOMRpcRoutingTableEntry(this.globalRpcId, this.keyId, impls);
    }
}

