/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.broker.impl;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.lmax.disruptor.EventFactory;
import java.util.Collection;
import org.opendaylight.controller.md.sal.dom.api.DOMNotification;
import org.opendaylight.controller.md.sal.dom.api.DOMNotificationListener;
import org.opendaylight.yangtools.concepts.ListenerRegistration;

final class DOMNotificationRouterEvent {
    public static final EventFactory<DOMNotificationRouterEvent> FACTORY = new EventFactory<DOMNotificationRouterEvent>(){

        public DOMNotificationRouterEvent newInstance() {
            return new DOMNotificationRouterEvent();
        }
    };
    private Collection<ListenerRegistration<? extends DOMNotificationListener>> subscribers;
    private DOMNotification notification;
    private SettableFuture<Void> future;

    private DOMNotificationRouterEvent() {
    }

    ListenableFuture<Void> initialize(DOMNotification notification, Collection<ListenerRegistration<? extends DOMNotificationListener>> subscribers) {
        this.notification = (DOMNotification)Preconditions.checkNotNull((Object)notification);
        this.subscribers = (Collection)Preconditions.checkNotNull(subscribers);
        this.future = SettableFuture.create();
        return this.future;
    }

    void deliverNotification() {
        for (ListenerRegistration<? extends DOMNotificationListener> r : this.subscribers) {
            DOMNotificationListener l = (DOMNotificationListener)r.getInstance();
            if (l == null) continue;
            l.onNotification(this.notification);
        }
    }

    void setFuture() {
        this.future.set(null);
    }
}

