/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.broker.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.opendaylight.controller.md.sal.common.api.data.TransactionCommitFailedException;
import org.opendaylight.controller.md.sal.dom.api.DOMDataWriteTransaction;
import org.opendaylight.controller.md.sal.dom.broker.impl.TransactionCommitFailedExceptionMapper;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.yangtools.util.DurationStatisticsTracker;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CommitCoordinationTask
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(CommitCoordinationTask.class);
    private final Collection<DOMStoreThreePhaseCommitCohort> cohorts;
    private final DurationStatisticsTracker commitStatTracker;
    private final DOMDataWriteTransaction tx;

    public CommitCoordinationTask(DOMDataWriteTransaction transaction, Collection<DOMStoreThreePhaseCommitCohort> cohorts, DurationStatisticsTracker commitStatTracker) {
        this.tx = (DOMDataWriteTransaction)Preconditions.checkNotNull((Object)transaction, (Object)"transaction must not be null");
        this.cohorts = (Collection)Preconditions.checkNotNull(cohorts, (Object)"cohorts must not be null");
        this.commitStatTracker = commitStatTracker;
    }

    @Override
    public Void call() throws TransactionCommitFailedException {
        long startTime = this.commitStatTracker != null ? System.nanoTime() : 0L;
        Phase phase = Phase.canCommit;
        try {
            LOG.debug("Transaction {}: canCommit Started", this.tx.getIdentifier());
            this.canCommitBlocking();
            phase = Phase.preCommit;
            LOG.debug("Transaction {}: preCommit Started", this.tx.getIdentifier());
            this.preCommitBlocking();
            phase = Phase.doCommit;
            LOG.debug("Transaction {}: doCommit Started", this.tx.getIdentifier());
            this.commitBlocking();
            LOG.debug("Transaction {}: doCommit completed", this.tx.getIdentifier());
            Void void_ = null;
            return void_;
        }
        catch (TransactionCommitFailedException e) {
            LOG.warn("Tx: {} Error during phase {}, starting Abort", new Object[]{this.tx.getIdentifier(), phase, e});
            this.abortBlocking(e);
            throw e;
        }
        finally {
            if (this.commitStatTracker != null) {
                this.commitStatTracker.addDuration(System.nanoTime() - startTime);
            }
        }
    }

    private void canCommitBlocking() throws TransactionCommitFailedException {
        for (ListenableFuture<?> canCommit : this.canCommitAll()) {
            try {
                Boolean result = (Boolean)canCommit.get();
                if (result != null && result.booleanValue()) continue;
                throw new TransactionCommitFailedException("Can Commit failed, no detailed cause available.", new RpcError[0]);
            }
            catch (InterruptedException | ExecutionException e) {
                throw (TransactionCommitFailedException)((Object)TransactionCommitFailedExceptionMapper.CAN_COMMIT_ERROR_MAPPER.apply(e));
            }
        }
    }

    private ListenableFuture<?>[] canCommitAll() {
        ListenableFuture[] ops = new ListenableFuture[this.cohorts.size()];
        int i = 0;
        for (DOMStoreThreePhaseCommitCohort cohort : this.cohorts) {
            ops[i++] = cohort.canCommit();
        }
        return ops;
    }

    private void preCommitBlocking() throws TransactionCommitFailedException {
        ListenableFuture<?>[] preCommitFutures = this.preCommitAll();
        try {
            for (ListenableFuture<?> future : preCommitFutures) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw (TransactionCommitFailedException)((Object)TransactionCommitFailedExceptionMapper.PRE_COMMIT_MAPPER.apply(e));
        }
    }

    private ListenableFuture<?>[] preCommitAll() {
        ListenableFuture[] ops = new ListenableFuture[this.cohorts.size()];
        int i = 0;
        for (DOMStoreThreePhaseCommitCohort cohort : this.cohorts) {
            ops[i++] = cohort.preCommit();
        }
        return ops;
    }

    private void commitBlocking() throws TransactionCommitFailedException {
        ListenableFuture<?>[] commitFutures = this.commitAll();
        try {
            for (ListenableFuture<?> future : commitFutures) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw (TransactionCommitFailedException)((Object)TransactionCommitFailedExceptionMapper.COMMIT_ERROR_MAPPER.apply(e));
        }
    }

    private ListenableFuture<?>[] commitAll() {
        ListenableFuture[] ops = new ListenableFuture[this.cohorts.size()];
        int i = 0;
        for (DOMStoreThreePhaseCommitCohort cohort : this.cohorts) {
            ops[i++] = cohort.commit();
        }
        return ops;
    }

    private void abortBlocking(TransactionCommitFailedException originalCause) throws TransactionCommitFailedException {
        Throwable cause = originalCause;
        try {
            this.abortAsyncAll().get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Tx: {} Error during Abort.", this.tx.getIdentifier(), (Object)e);
            cause = new IllegalStateException("Abort failed.", e);
            cause.addSuppressed(e);
        }
        Throwables.propagateIfPossible((Throwable)cause, TransactionCommitFailedException.class);
    }

    private ListenableFuture<Void> abortAsyncAll() {
        ListenableFuture[] ops = new ListenableFuture[this.cohorts.size()];
        int i = 0;
        for (DOMStoreThreePhaseCommitCohort cohort : this.cohorts) {
            ops[i++] = cohort.abort();
        }
        ListenableFuture compositeResult = Futures.allAsList((ListenableFuture[])ops);
        return compositeResult;
    }

    private static enum Phase {
        canCommit,
        preCommit,
        doCommit;

    }
}

