/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.broker.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.CheckedFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcException;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcImplementation;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcResult;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

abstract class AbstractDOMRpcRoutingTableEntry {
    private final Map<YangInstanceIdentifier, List<DOMRpcImplementation>> impls;
    private final SchemaPath schemaPath;

    protected AbstractDOMRpcRoutingTableEntry(SchemaPath schemaPath, Map<YangInstanceIdentifier, List<DOMRpcImplementation>> impls) {
        this.schemaPath = (SchemaPath)Preconditions.checkNotNull((Object)schemaPath);
        this.impls = (Map)Preconditions.checkNotNull(impls);
    }

    protected final SchemaPath getSchemaPath() {
        return this.schemaPath;
    }

    protected final List<DOMRpcImplementation> getImplementations(YangInstanceIdentifier context) {
        return this.impls.get(context);
    }

    final Map<YangInstanceIdentifier, List<DOMRpcImplementation>> getImplementations() {
        return this.impls;
    }

    public boolean containsContext(YangInstanceIdentifier contextReference) {
        return this.impls.containsKey(contextReference);
    }

    final Set<YangInstanceIdentifier> registeredIdentifiers() {
        return this.impls.keySet();
    }

    final AbstractDOMRpcRoutingTableEntry add(DOMRpcImplementation implementation, List<YangInstanceIdentifier> newRpcs) {
        ImmutableMap.Builder vb = ImmutableMap.builder();
        for (Map.Entry<YangInstanceIdentifier, List<DOMRpcImplementation>> ve : this.impls.entrySet()) {
            if (newRpcs.remove(ve.getKey())) {
                ArrayList<DOMRpcImplementation> i = new ArrayList<DOMRpcImplementation>(ve.getValue().size() + 1);
                i.addAll((Collection)ve.getValue());
                i.add(implementation);
                vb.put((Object)ve.getKey(), i);
                continue;
            }
            vb.put(ve);
        }
        for (YangInstanceIdentifier ii : newRpcs) {
            ArrayList<DOMRpcImplementation> impl = new ArrayList<DOMRpcImplementation>(1);
            impl.add(implementation);
            vb.put((Object)ii, impl);
        }
        return this.newInstance((Map<YangInstanceIdentifier, List<DOMRpcImplementation>>)vb.build());
    }

    final AbstractDOMRpcRoutingTableEntry remove(DOMRpcImplementation implementation, List<YangInstanceIdentifier> removed) {
        ImmutableMap.Builder vb = ImmutableMap.builder();
        for (Map.Entry<YangInstanceIdentifier, List<DOMRpcImplementation>> ve : this.impls.entrySet()) {
            if (removed.remove(ve.getKey())) {
                ArrayList i = new ArrayList(ve.getValue());
                i.remove(implementation);
                if (i.isEmpty()) continue;
                vb.put((Object)ve.getKey(), i);
                continue;
            }
            vb.put(ve);
        }
        ImmutableMap v = vb.build();
        return v.isEmpty() ? null : this.newInstance((Map<YangInstanceIdentifier, List<DOMRpcImplementation>>)v);
    }

    protected abstract CheckedFuture<DOMRpcResult, DOMRpcException> invokeRpc(NormalizedNode<?, ?> var1);

    protected abstract AbstractDOMRpcRoutingTableEntry newInstance(Map<YangInstanceIdentifier, List<DOMRpcImplementation>> var1);
}

