/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.md.sal.dom.impl;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.yang.md.sal.dom.impl.AbstractDomInmemoryDataBrokerModule;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.TransactionCommitDeadlockException;
import org.opendaylight.controller.md.sal.common.util.jmx.AbstractMXBean;
import org.opendaylight.controller.md.sal.common.util.jmx.ThreadExecutorStatsMXBeanImpl;
import org.opendaylight.controller.md.sal.dom.broker.impl.SerializedDOMDataBroker;
import org.opendaylight.controller.md.sal.dom.broker.impl.jmx.CommitStatsMXBeanImpl;
import org.opendaylight.controller.md.sal.dom.store.impl.InMemoryDOMDataStoreFactory;
import org.opendaylight.controller.sal.core.api.model.SchemaService;
import org.opendaylight.controller.sal.core.spi.data.DOMStore;
import org.opendaylight.yangtools.util.DurationStatisticsTracker;
import org.opendaylight.yangtools.util.concurrent.DeadlockDetectingListeningExecutorService;
import org.opendaylight.yangtools.util.concurrent.SpecialExecutors;

public final class DomInmemoryDataBrokerModule
extends AbstractDomInmemoryDataBrokerModule {
    private static final String JMX_BEAN_TYPE = "DOMDataBroker";

    public DomInmemoryDataBrokerModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public DomInmemoryDataBrokerModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, DomInmemoryDataBrokerModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, oldModule, oldInstance);
    }

    @Override
    protected void customValidation() {
    }

    public AutoCloseable createInstance() {
        ThreadExecutorStatsMXBeanImpl commitFutureStatsMXBean;
        DOMStore configStore;
        DOMStore operStore = this.getOperationalDataStoreDependency();
        if (operStore == null) {
            operStore = InMemoryDOMDataStoreFactory.create((String)"DOM-OPER", (SchemaService)this.getSchemaServiceDependency());
        }
        if ((configStore = this.getConfigDataStoreDependency()) == null) {
            configStore = InMemoryDOMDataStoreFactory.create((String)"DOM-CFG", (SchemaService)this.getSchemaServiceDependency());
        }
        EnumMap<LogicalDatastoreType, DOMStore> datastores = new EnumMap<LogicalDatastoreType, DOMStore>(LogicalDatastoreType.class);
        datastores.put(LogicalDatastoreType.OPERATIONAL, operStore);
        datastores.put(LogicalDatastoreType.CONFIGURATION, configStore);
        ExecutorService listenableFutureExecutor = SpecialExecutors.newBlockingBoundedCachedThreadPool((int)this.getMaxDataBrokerFutureCallbackPoolSize(), (int)this.getMaxDataBrokerFutureCallbackQueueSize(), (String)"CommitFutures");
        final ArrayList mBeans = Lists.newArrayList();
        ExecutorService commitExecutor = SpecialExecutors.newBoundedSingleThreadExecutor((int)this.getMaxDataBrokerCommitQueueSize(), (String)"WriteTxCommit");
        SerializedDOMDataBroker sdb = new SerializedDOMDataBroker(datastores, (ListeningExecutorService)new DeadlockDetectingListeningExecutorService(commitExecutor, TransactionCommitDeadlockException.DEADLOCK_EXCEPTION_SUPPLIER, (Executor)listenableFutureExecutor));
        DurationStatisticsTracker commitStatsTracker = sdb.getCommitStatsTracker();
        ThreadExecutorStatsMXBeanImpl commitExecutorStatsMXBean = ThreadExecutorStatsMXBeanImpl.create((Executor)commitExecutor, (String)"CommitExecutorStats", (String)JMX_BEAN_TYPE, null);
        if (commitExecutorStatsMXBean != null) {
            mBeans.add(commitExecutorStatsMXBean);
        }
        if (commitStatsTracker != null) {
            CommitStatsMXBeanImpl commitStatsMXBean = new CommitStatsMXBeanImpl(commitStatsTracker, JMX_BEAN_TYPE);
            commitStatsMXBean.registerMBean();
            mBeans.add(commitStatsMXBean);
        }
        if ((commitFutureStatsMXBean = ThreadExecutorStatsMXBeanImpl.create((Executor)listenableFutureExecutor, (String)"CommitFutureExecutorStats", (String)JMX_BEAN_TYPE, null)) != null) {
            mBeans.add(commitFutureStatsMXBean);
        }
        sdb.setCloseable(new AutoCloseable(){

            @Override
            public void close() {
                for (AbstractMXBean mBean : mBeans) {
                    mBean.unregisterMBean();
                }
            }
        });
        return sdb;
    }
}

