/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.md.sal.dom.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.yang.md.sal.dom.impl.AbstractDomBrokerImplModule;
import org.opendaylight.controller.md.sal.dom.api.DOMDataBroker;
import org.opendaylight.controller.md.sal.dom.api.DOMMountPointService;
import org.opendaylight.controller.md.sal.dom.api.DOMNotificationPublishService;
import org.opendaylight.controller.md.sal.dom.api.DOMNotificationService;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcProviderService;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcService;
import org.opendaylight.controller.md.sal.dom.broker.impl.DOMNotificationRouter;
import org.opendaylight.controller.md.sal.dom.broker.impl.DOMRpcRouter;
import org.opendaylight.controller.md.sal.dom.broker.impl.mount.DOMMountPointServiceImpl;
import org.opendaylight.controller.sal.core.api.BrokerService;
import org.opendaylight.controller.sal.core.api.model.SchemaService;
import org.opendaylight.controller.sal.dom.broker.BrokerImpl;
import org.opendaylight.controller.sal.dom.broker.GlobalBundleScanningSchemaServiceImpl;
import org.opendaylight.yangtools.yang.model.api.SchemaContextListener;

public final class DomBrokerImplModule
extends AbstractDomBrokerImplModule {
    public DomBrokerImplModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public DomBrokerImplModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, DomBrokerImplModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, oldModule, oldInstance);
    }

    @Override
    public void validate() {
        super.validate();
        long depth = this.getNotificationQueueDepth().getValue();
        Preconditions.checkArgument((Long.lowestOneBit(depth) == Long.highestOneBit(depth) ? 1 : 0) != 0, (String)"Queue depth %s is not power-of-two", (Object[])new Object[]{depth});
    }

    public AutoCloseable createInstance() {
        DOMDataBroker asyncBroker = this.getAsyncDataBrokerDependency();
        MutableClassToInstanceMap services = MutableClassToInstanceMap.create();
        DOMNotificationRouter domNotificationRouter = DOMNotificationRouter.create(this.getNotificationQueueDepth().getValue().intValue(), this.getNotificationQueueSpin().longValue(), this.getNotificationQueuePark().longValue(), TimeUnit.MILLISECONDS);
        services.putInstance(DOMNotificationService.class, (Object)domNotificationRouter);
        services.putInstance(DOMNotificationPublishService.class, (Object)domNotificationRouter);
        SchemaService schemaService = this.getSchemaServiceImpl();
        services.putInstance(SchemaService.class, (Object)schemaService);
        services.putInstance(DOMDataBroker.class, (Object)asyncBroker);
        DOMRpcRouter rpcRouter = new DOMRpcRouter();
        schemaService.registerSchemaContextListener((SchemaContextListener)rpcRouter);
        services.putInstance(DOMRpcService.class, (Object)rpcRouter);
        services.putInstance(DOMRpcProviderService.class, (Object)rpcRouter);
        DOMMountPointServiceImpl mountService = new DOMMountPointServiceImpl();
        services.putInstance(DOMMountPointService.class, (Object)mountService);
        return new BrokerImpl(rpcRouter, (ClassToInstanceMap<BrokerService>)services);
    }

    private SchemaService getSchemaServiceImpl() {
        GlobalBundleScanningSchemaServiceImpl schemaService = this.getRootSchemaService() != null ? this.getRootSchemaServiceDependency() : GlobalBundleScanningSchemaServiceImpl.getInstance();
        return schemaService;
    }
}

