/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.md.sal.dom.impl;

import java.util.Objects;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.RuntimeBeanRegistratorAwareModule;
import org.opendaylight.controller.config.api.annotations.Description;
import org.opendaylight.controller.config.api.annotations.RequireInterface;
import org.opendaylight.controller.config.api.runtime.RootRuntimeBeanRegistrator;
import org.opendaylight.controller.config.spi.AbstractModule;
import org.opendaylight.controller.config.yang.md.sal.dom.BrokerServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.dom.DOMDataBrokerServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.dom.SchemaServiceServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.dom.impl.DomBrokerImplModuleMXBean;
import org.opendaylight.controller.config.yang.md.sal.dom.impl.DomBrokerImplRuntimeRegistrator;
import org.opendaylight.controller.md.sal.dom.api.DOMDataBroker;
import org.opendaylight.controller.sal.core.api.model.SchemaService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.MaxQueueDepth;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ModuleQName(revision="2013-10-28", name="opendaylight-sal-dom-broker-impl", namespace="urn:opendaylight:params:xml:ns:yang:controller:md:sal:dom:impl")
public abstract class AbstractDomBrokerImplModule
extends AbstractModule<AbstractDomBrokerImplModule>
implements DomBrokerImplModuleMXBean,
BrokerServiceInterface,
RuntimeBeanRegistratorAwareModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDomBrokerImplModule.class);
    public static final JmxAttribute rootSchemaServiceJmxAttribute = new JmxAttribute("RootSchemaService");
    private ObjectName rootSchemaService;
    public static final JmxAttribute asyncDataBrokerJmxAttribute = new JmxAttribute("AsyncDataBroker");
    private ObjectName asyncDataBroker;
    public static final JmxAttribute notificationQueueParkJmxAttribute = new JmxAttribute("NotificationQueuePark");
    private Integer notificationQueuePark = new Integer("30");
    public static final JmxAttribute notificationQueueSpinJmxAttribute = new JmxAttribute("NotificationQueueSpin");
    private Integer notificationQueueSpin = new Integer("1");
    public static final JmxAttribute notificationQueueDepthJmxAttribute = new JmxAttribute("NotificationQueueDepth");
    private MaxQueueDepth notificationQueueDepth = new MaxQueueDepth(new Long("65536"));
    private DomBrokerImplRuntimeRegistrator rootRuntimeBeanRegistratorWrapper;
    private SchemaService rootSchemaServiceDependency;
    private DOMDataBroker asyncDataBrokerDependency;

    public AbstractDomBrokerImplModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public AbstractDomBrokerImplModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractDomBrokerImplModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, (AbstractModule)oldModule, oldInstance);
    }

    public DomBrokerImplRuntimeRegistrator getRootRuntimeBeanRegistratorWrapper() {
        return this.rootRuntimeBeanRegistratorWrapper;
    }

    public void setRuntimeBeanRegistrator(RootRuntimeBeanRegistrator rootRuntimeRegistrator) {
        this.rootRuntimeBeanRegistratorWrapper = new DomBrokerImplRuntimeRegistrator(rootRuntimeRegistrator);
    }

    public void validate() {
        if (this.rootSchemaService != null) {
            this.dependencyResolver.validateDependency(SchemaServiceServiceInterface.class, this.rootSchemaService, rootSchemaServiceJmxAttribute);
        }
        if (this.asyncDataBroker != null) {
            this.dependencyResolver.validateDependency(DOMDataBrokerServiceInterface.class, this.asyncDataBroker, asyncDataBrokerJmxAttribute);
        }
        this.customValidation();
    }

    protected void customValidation() {
    }

    protected final SchemaService getRootSchemaServiceDependency() {
        return this.rootSchemaServiceDependency;
    }

    protected final DOMDataBroker getAsyncDataBrokerDependency() {
        return this.asyncDataBrokerDependency;
    }

    protected final void resolveDependencies() {
        if (this.asyncDataBroker != null) {
            this.asyncDataBrokerDependency = (DOMDataBroker)this.dependencyResolver.resolveInstance(DOMDataBroker.class, this.asyncDataBroker, asyncDataBrokerJmxAttribute);
        }
        if (this.rootSchemaService != null) {
            this.rootSchemaServiceDependency = (SchemaService)this.dependencyResolver.resolveInstance(SchemaService.class, this.rootSchemaService, rootSchemaServiceJmxAttribute);
        }
    }

    public boolean canReuseInstance(AbstractDomBrokerImplModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public boolean isSame(AbstractDomBrokerImplModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        if (!Objects.deepEquals(this.rootSchemaService, other.rootSchemaService)) {
            return false;
        }
        if (this.rootSchemaService != null && !this.dependencyResolver.canReuseDependency(this.rootSchemaService, rootSchemaServiceJmxAttribute)) {
            return false;
        }
        if (!Objects.deepEquals(this.asyncDataBroker, other.asyncDataBroker)) {
            return false;
        }
        if (this.asyncDataBroker != null && !this.dependencyResolver.canReuseDependency(this.asyncDataBroker, asyncDataBrokerJmxAttribute)) {
            return false;
        }
        if (!Objects.deepEquals(this.notificationQueuePark, other.notificationQueuePark)) {
            return false;
        }
        if (!Objects.deepEquals(this.notificationQueueSpin, other.notificationQueueSpin)) {
            return false;
        }
        return Objects.deepEquals(this.notificationQueueDepth, other.notificationQueueDepth);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractDomBrokerImplModule that = (AbstractDomBrokerImplModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    public ObjectName getRootSchemaService() {
        return this.rootSchemaService;
    }

    @Override
    @RequireInterface(value=SchemaServiceServiceInterface.class)
    public void setRootSchemaService(ObjectName rootSchemaService) {
        this.rootSchemaService = rootSchemaService;
    }

    @Override
    public ObjectName getAsyncDataBroker() {
        return this.asyncDataBroker;
    }

    @Override
    @RequireInterface(value=DOMDataBrokerServiceInterface.class)
    public void setAsyncDataBroker(ObjectName asyncDataBroker) {
        this.asyncDataBroker = asyncDataBroker;
    }

    @Override
    public Integer getNotificationQueuePark() {
        return this.notificationQueuePark;
    }

    @Override
    @Description(value="Number of milliseconds notification queue should park for new requests before blocking.")
    public void setNotificationQueuePark(Integer notificationQueuePark) {
        this.notificationQueuePark = notificationQueuePark;
    }

    @Override
    public Integer getNotificationQueueSpin() {
        return this.notificationQueueSpin;
    }

    @Override
    @Description(value="Number of milliseconds notification queue should spin for new requests before parking.")
    public void setNotificationQueueSpin(Integer notificationQueueSpin) {
        this.notificationQueueSpin = notificationQueueSpin;
    }

    @Override
    public MaxQueueDepth getNotificationQueueDepth() {
        return this.notificationQueueDepth;
    }

    @Override
    @Description(value="Maximum number of elements in the notification queue, must be power-of-two.")
    public void setNotificationQueueDepth(MaxQueueDepth notificationQueueDepth) {
        this.notificationQueueDepth = notificationQueueDepth;
    }

    public Logger getLogger() {
        return LOGGER;
    }
}

