/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.it.base;

import com.google.common.base.Stopwatch;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.junit.Before;
import org.junit.Rule;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.opendaylight.controller.config.util.ConfigRegistryJMXClient;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.OptionUtils;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.karaf.options.LogLevelOption;
import org.ops4j.pax.exam.options.MavenArtifactUrlReference;
import org.ops4j.pax.exam.options.MavenUrlReference;
import org.ops4j.pax.exam.options.UrlReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigTestBase {
    private static final String MAVEN_REPO_LOCAL = "maven.repo.local";
    private static final String ORG_OPS4J_PAX_URL_MVN_LOCAL_REPOSITORY = "org.ops4j.pax.url.mvn.localRepository";
    private static final String ETC_ORG_OPS4J_PAX_URL_MVN_CFG = "etc/org.ops4j.pax.url.mvn.cfg";
    private static final String ETC_ORG_OPS4J_PAX_LOGGING_CFG = "etc/org.ops4j.pax.logging.cfg";
    private static final String PAX_EXAM_UNPACK_DIRECTORY = "target/exam";
    private static final String KARAF_DEBUG_PORT = "5005";
    private static final String KARAF_DEBUG_PROP = "karaf.debug";
    private static final String KEEP_UNPACK_DIRECTORY_PROP = "karaf.keep.unpack";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractConfigTestBase.class);
    public static final String ORG_OPS4J_PAX_LOGGING_CFG = "etc/org.ops4j.pax.logging.cfg";
    private static final String KARAF_DISTRO_TYPE = "zip";
    private static final String KARAF_DISTRO_ARTIFACTID = "opendaylight-karaf-empty";
    private static final String KARAF_DISTRO_GROUPID = "org.opendaylight.odlparent";
    private static final String KARAF_DISTRO_VERSION_PROP = "karaf.distro.version";
    private static final String KARAF_DISTRO_TYPE_PROP = "karaf.distro.type";
    private static final String KARAF_DISTRO_ARTIFACTID_PROP = "karaf.distro.artifactId";
    private static final String KARAF_DISTRO_GROUPID_PROP = "karaf.distro.groupId";
    private static final String PROPERTIES_FILENAME = "abstractconfigtestbase.properties";
    private static final int MODULE_TIMEOUT_MILLIS = 60000;
    @Rule
    public TestRule watcher = new TestWatcher(){

        protected void starting(Description description) {
            LOG.info("TestWatcher: Starting test: {}", (Object)description.getDisplayName());
        }

        protected void finished(Description description) {
            LOG.info("TestWatcher: Finished test: {}", (Object)description.getDisplayName());
        }

        protected void succeeded(Description description) {
            LOG.info("TestWatcher: Test succeeded: {}", (Object)description.getDisplayName());
        }

        protected void failed(Throwable ex, Description description) {
            LOG.info("TestWatcher: Test failed: {}", (Object)description.getDisplayName(), (Object)ex);
        }

        protected void skipped(AssumptionViolatedException ex, Description description) {
            LOG.info("TestWatcher: Test skipped: {} ", (Object)description.getDisplayName(), (Object)ex);
        }
    };

    @Deprecated
    public String getModuleName() {
        return null;
    }

    @Deprecated
    public String getInstanceName() {
        return null;
    }

    public abstract MavenUrlReference getFeatureRepo();

    public abstract String getFeatureName();

    public Option getLoggingOption() {
        Option option = KarafDistributionOption.editConfigurationFilePut((String)"etc/org.ops4j.pax.logging.cfg", (String)this.logConfiguration(AbstractConfigTestBase.class), (Object)LogLevelOption.LogLevel.INFO.name());
        return option;
    }

    protected Option[] getAdditionalOptions() {
        return null;
    }

    public String logConfiguration(Class<?> klazz) {
        return "log4j.logger." + klazz.getPackage().getName();
    }

    public String getKarafDistro() {
        String groupId = System.getProperty(KARAF_DISTRO_GROUPID_PROP, KARAF_DISTRO_GROUPID);
        String artifactId = System.getProperty(KARAF_DISTRO_ARTIFACTID_PROP, KARAF_DISTRO_ARTIFACTID);
        String version = System.getProperty(KARAF_DISTRO_VERSION_PROP);
        String type = System.getProperty(KARAF_DISTRO_TYPE_PROP, KARAF_DISTRO_TYPE);
        if (version == null) {
            Properties abstractConfigTestBaseProps = new Properties();
            try (InputStream abstractConfigTestBaseInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(PROPERTIES_FILENAME);){
                abstractConfigTestBaseProps.load(abstractConfigTestBaseInputStream);
            }
            catch (IOException e) {
                LOG.error("Unable to load {} to determine the Karaf version", (Object)PROPERTIES_FILENAME, (Object)e);
            }
            version = abstractConfigTestBaseProps.getProperty(KARAF_DISTRO_VERSION_PROP);
        }
        MavenArtifactUrlReference karafUrl = CoreOptions.maven().groupId(groupId).artifactId(artifactId).version(version).type(type);
        return karafUrl.getURL();
    }

    protected Option mvnLocalRepoOption() {
        String mvnRepoLocal = System.getProperty(MAVEN_REPO_LOCAL, "");
        LOG.info("mvnLocalRepo \"{}\"", (Object)mvnRepoLocal);
        return KarafDistributionOption.editConfigurationFilePut((String)ETC_ORG_OPS4J_PAX_URL_MVN_CFG, (String)ORG_OPS4J_PAX_URL_MVN_LOCAL_REPOSITORY, (Object)mvnRepoLocal);
    }

    @Configuration
    public Option[] config() {
        Option[] options = new Option[]{CoreOptions.when((boolean)Boolean.getBoolean(KARAF_DEBUG_PROP)).useOptions(new Option[]{KarafDistributionOption.debugConfiguration((String)KARAF_DEBUG_PORT, (boolean)true)}), KarafDistributionOption.karafDistributionConfiguration().frameworkUrl(this.getKarafDistro()).unpackDirectory(new File(PAX_EXAM_UNPACK_DIRECTORY)).useDeployFolder(false), CoreOptions.when((boolean)Boolean.getBoolean(KEEP_UNPACK_DIRECTORY_PROP)).useOptions(new Option[]{KarafDistributionOption.keepRuntimeFolder()}), KarafDistributionOption.features((UrlReference)this.getFeatureRepo(), (String[])new String[]{this.getFeatureName()}), CoreOptions.mavenBundle((String)"org.apache.aries.quiesce", (String)"org.apache.aries.quiesce.api", (String)"1.0.0"), this.getLoggingOption(), this.mvnLocalRepoOption(), KarafDistributionOption.editConfigurationFilePut((String)"etc/org.ops4j.pax.logging.cfg", (String)"log4j.rootLogger", (Object)"INFO, stdout, osgi:*")};
        return OptionUtils.combine((Option[])options, (Option[])this.getAdditionalOptions());
    }

    @Before
    public void setup() throws Exception {
        String moduleName = this.getModuleName();
        String instanceName = this.getInstanceName();
        if (moduleName == null || instanceName == null) {
            return;
        }
        LOG.info("Module: {} Instance: {} attempting to configure.", (Object)moduleName, (Object)instanceName);
        Stopwatch stopWatch = Stopwatch.createStarted();
        ObjectName objectName = null;
        for (int i = 0; i < 60000; ++i) {
            try {
                ConfigRegistryJMXClient configRegistryClient = new ConfigRegistryJMXClient(ManagementFactory.getPlatformMBeanServer());
                objectName = configRegistryClient.lookupConfigBean(moduleName, instanceName);
                LOG.info("Module: {} Instance: {} ObjectName: {}.", new Object[]{moduleName, instanceName, objectName});
                break;
            }
            catch (Exception e) {
                if (i >= 60000) {
                    throw e;
                }
                Thread.sleep(1L);
                continue;
            }
        }
        if (objectName == null) {
            throw new RuntimeException("NOT FOUND Module: " + moduleName + " Instance: " + instanceName + " configured after " + stopWatch.elapsed(TimeUnit.MILLISECONDS) + " ms");
        }
        LOG.info("Module: {} Instance: {} configured after {} ms", new Object[]{moduleName, instanceName, stopWatch.elapsed(TimeUnit.MILLISECONDS)});
    }
}

