/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.api.jmx;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import javax.management.ObjectName;

@Immutable
public class CommitStatus {
    private final List<ObjectName> newInstances;
    private final List<ObjectName> reusedInstances;
    private final List<ObjectName> recreatedInstances;

    @ConstructorProperties(value={"newInstances", "reusedInstances", "recreatedInstances"})
    public CommitStatus(List<ObjectName> newInstances, List<ObjectName> reusedInstances, List<ObjectName> recreatedInstances) {
        this.newInstances = Collections.unmodifiableList(newInstances);
        this.reusedInstances = Collections.unmodifiableList(reusedInstances);
        this.recreatedInstances = Collections.unmodifiableList(recreatedInstances);
    }

    public List<ObjectName> getNewInstances() {
        return this.newInstances;
    }

    public List<ObjectName> getReusedInstances() {
        return this.reusedInstances;
    }

    public List<ObjectName> getRecreatedInstances() {
        return this.recreatedInstances;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.newInstances == null ? 0 : this.newInstances.hashCode());
        result = 31 * result + (this.recreatedInstances == null ? 0 : this.recreatedInstances.hashCode());
        result = 31 * result + (this.reusedInstances == null ? 0 : this.reusedInstances.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommitStatus other = (CommitStatus)obj;
        if (this.newInstances == null ? other.newInstances != null : !this.newInstances.equals(other.newInstances)) {
            return false;
        }
        if (this.recreatedInstances == null ? other.recreatedInstances != null : !this.recreatedInstances.equals(other.recreatedInstances)) {
            return false;
        }
        return !(this.reusedInstances == null ? other.reusedInstances != null : !this.reusedInstances.equals(other.reusedInstances));
    }

    public String toString() {
        return "CommitStatus [newInstances=" + this.newInstances + ", reusedInstances=" + this.reusedInstances + ", recreatedInstances=" + this.recreatedInstances + "]";
    }
}

