/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.spi;

import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.spi.Module;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractModule<M extends AbstractModule<M>>
implements Module {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractModule.class);
    protected final DependencyResolver dependencyResolver;
    protected final ModuleIdentifier identifier;
    private AutoCloseable oldInstance;
    private M oldModule;
    private AutoCloseable instance;

    public AbstractModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        this(identifier, dependencyResolver, null, null);
    }

    public AbstractModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, M oldModule, AutoCloseable oldInstance) {
        this.identifier = identifier;
        this.dependencyResolver = dependencyResolver;
        this.oldModule = oldModule;
        this.oldInstance = oldInstance;
    }

    public ModuleIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public final AutoCloseable getInstance() {
        if (this.instance == null) {
            if (this.oldInstance != null && this.canReuseInstance(this.oldModule)) {
                this.resolveDependencies();
                this.instance = this.reuseInstance(this.oldInstance);
            } else {
                if (this.oldInstance != null) {
                    try {
                        this.oldInstance.close();
                    }
                    catch (Exception e) {
                        LOG.error("An error occurred while closing old instance {} for module {}", new Object[]{this.oldInstance, this.getIdentifier(), e});
                    }
                }
                this.resolveDependencies();
                this.instance = this.createInstance();
                if (this.instance == null) {
                    throw new IllegalStateException("Error in createInstance - null is not allowed as return value. Module: " + this.getIdentifier());
                }
            }
            this.oldInstance = null;
            this.oldModule = null;
        }
        return this.instance;
    }

    protected abstract AutoCloseable createInstance();

    @Override
    public final boolean canReuse(Module oldModule) {
        return this.getClass().isInstance(oldModule) ? this.canReuseInstance((AbstractModule)oldModule) : false;
    }

    protected abstract boolean canReuseInstance(M var1);

    protected AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    protected abstract void resolveDependencies();
}

