/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import com.google.common.annotations.Beta;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.opendaylight.yangtools.concepts.WritableObject;

@Beta
public enum PersistenceProtocol implements WritableObject
{
    ABORT{

        @Override
        byte byteValue() {
            return 1;
        }
    }
    ,
    SIMPLE{

        @Override
        byte byteValue() {
            return 2;
        }
    }
    ,
    THREE_PHASE{

        @Override
        byte byteValue() {
            return 3;
        }
    }
    ,
    READY{

        @Override
        byte byteValue() {
            return 4;
        }
    };


    public final void writeTo(DataOutput out) throws IOException {
        out.writeByte(this.byteValue());
    }

    public static PersistenceProtocol readFrom(DataInput in) throws IOException {
        return PersistenceProtocol.valueOf(in.readByte());
    }

    abstract byte byteValue();

    static int byteValue(PersistenceProtocol finish) {
        return finish == null ? (byte)0 : finish.byteValue();
    }

    static PersistenceProtocol valueOf(byte value) {
        switch (value) {
            case 0: {
                return null;
            }
            case 1: {
                return ABORT;
            }
            case 2: {
                return SIMPLE;
            }
            case 3: {
                return THREE_PHASE;
            }
            case 4: {
                return READY;
            }
        }
        throw new IllegalArgumentException("Unhandled byte value " + value);
    }
}

