/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.RangeSet;
import com.google.common.primitives.UnsignedLong;
import org.opendaylight.controller.cluster.access.concepts.RequestException;

@Beta
public final class DeadTransactionException
extends RequestException {
    private static final long serialVersionUID = 1L;
    private final RangeSet<UnsignedLong> purgedIdentifiers;

    public DeadTransactionException(RangeSet<UnsignedLong> purgedIdentifiers) {
        super("Transactions " + purgedIdentifiers + " have been purged");
        this.purgedIdentifiers = ImmutableRangeSet.copyOf(purgedIdentifiers);
    }

    @Override
    public boolean isRetriable() {
        return false;
    }

    public RangeSet<UnsignedLong> getPurgedIdentifier() {
        return this.purgedIdentifiers;
    }
}

