/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import akka.actor.ActorRef;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.opendaylight.controller.cluster.access.commands.AbstractReadTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.AbstractTransactionRequestProxy;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;

abstract class AbstractReadTransactionRequestProxyV1<T extends AbstractReadTransactionRequest<T>>
extends AbstractTransactionRequestProxy<T> {
    private static final long serialVersionUID = 1L;
    private boolean snapshotOnly;

    protected AbstractReadTransactionRequestProxyV1() {
    }

    AbstractReadTransactionRequestProxyV1(T request) {
        super(request);
        this.snapshotOnly = ((AbstractReadTransactionRequest)request).isSnapshotOnly();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.snapshotOnly);
    }

    @Override
    public void readExternal(ObjectInput in) throws ClassNotFoundException, IOException {
        super.readExternal(in);
        this.snapshotOnly = in.readBoolean();
    }

    @Override
    protected final T createRequest(TransactionIdentifier target, long sequence, ActorRef replyTo) {
        return this.createReadRequest(target, sequence, replyTo, this.snapshotOnly);
    }

    abstract T createReadRequest(TransactionIdentifier var1, long var2, ActorRef var4, boolean var5);
}

