/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.usm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpEngineImpl;
import com.sun.management.snmp.SnmpSecurityException;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.usm.SnmpUsmEnginePeer;
import com.sun.management.snmp.usm.SnmpUsmExceptionGenerator;
import com.sun.management.snmp.usm.SnmpUsmSecurityParameters;

class SnmpUsmTimelinessModule {
    private SnmpUsmExceptionGenerator gen = null;
    private int timeWindow = 150;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpUsmTimelinessModule");
    String dbgTag = "SnmpUsmTimelinessModule";

    SnmpUsmTimelinessModule(SnmpUsmExceptionGenerator gen) {
        this.gen = gen;
    }

    void handleResponseTimeliness(SnmpUsmEnginePeer peer, SnmpUsmSecurityParameters params) throws SnmpSecurityException {
        if (peer.getAuthoritativeEngineTime() == 0 && peer.getAuthoritativeEngineBoots() == 0) {
            if (logger.finerOn()) {
                logger.finer("handleResponseTimeliness", "Update time and boot: " + params.getAuthoritativeEngineTime() + ":" + params.getAuthoritativeEngineBoots());
            }
            peer.setAuthoritativeEngineTime(params.getAuthoritativeEngineTime());
            peer.setAuthoritativeEngineBoots(params.getAuthoritativeEngineBoots());
            peer.setAuthoritativeEngineLastReceivedTime(params.getAuthoritativeEngineTime());
            return;
        }
        int recBootTime = params.getAuthoritativeEngineTime();
        int recNbBoot = params.getAuthoritativeEngineBoots();
        if (recBootTime == 0 && recNbBoot == 0) {
            if (logger.finerOn()) {
                logger.finer("handleResponseTimeliness", "Received 0:0 value from an engineId discovery, ignoring it");
            }
            return;
        }
        int bootTime = peer.getAuthoritativeEngineTime();
        int nbBoot = peer.getAuthoritativeEngineBoots();
        int lastReceivedTime = peer.getAuthoritativeLastReceivedEngineTime();
        if (logger.finerOn()) {
            logger.finer("handleResponseTimeliness", "Local values time:boot: latestTime " + bootTime + ":" + nbBoot + ":" + lastReceivedTime + "\n" + "Received values time:boot: " + recBootTime + ":" + recNbBoot);
        }
        if (recNbBoot > nbBoot || recNbBoot == nbBoot && recBootTime > lastReceivedTime) {
            if (logger.finerOn()) {
                logger.finer("handleResponseTimeliness", "Timeliness succeeded, updating values.");
            }
            peer.setAuthoritativeEngineTime(recBootTime);
            peer.setAuthoritativeEngineBoots(recNbBoot);
            peer.setAuthoritativeEngineLastReceivedTime(recBootTime);
            return;
        }
        if (recNbBoot == Integer.MAX_VALUE) {
            SnmpSecurityException sec = new SnmpSecurityException("Received engine nb boots is 0x7FFFFFFF. Authoritative engine Id [" + peer.authoritativeEngineId + "] needs to be manually " + "reconfigured!");
            sec.status = 248;
            throw sec;
        }
        if (nbBoot > recNbBoot) {
            SnmpSecurityException sec = new SnmpSecurityException("Received engine nb boots is smaller than the local notion. The authoritative engine has been reconfigured. Reject the response!");
            sec.status = 248;
            throw sec;
        }
        if (nbBoot == recNbBoot && recBootTime < bootTime - this.getTimelinessWindow()) {
            SnmpSecurityException sec = new SnmpSecurityException("Received an engine time that is not in the right time frame. Reject the response!");
            sec.status = 248;
            throw sec;
        }
    }

    void handleTimeliness(SnmpEngineImpl engine, SnmpUsmSecurityParameters params) throws SnmpSecurityException, SnmpStatusException {
        int bootTime = params.getAuthoritativeEngineTime();
        int nbBoot = params.getAuthoritativeEngineBoots();
        if (bootTime == 0 && nbBoot == 0) {
            params.setAuthoritativeEngineTime(engine.getEngineTime());
            params.setAuthoritativeEngineBoots(engine.getEngineBoots());
            if (logger.finerOn()) {
                logger.finer("handleTimeliness", "Boot time discovery. Sending engine boot: " + params.getAuthoritativeEngineBoots() + ", engine time: " + params.getAuthoritativeEngineTime());
            }
            this.gen.genTimeWindowException(null, null, (byte)5, params);
        }
        if (nbBoot == Integer.MAX_VALUE || nbBoot != engine.getEngineBoots()) {
            if (logger.finerOn()) {
                logger.finer("handleTimeliness", "Invalid boots: Received boot: " + nbBoot + ", Local engine boot: " + engine.getEngineBoots());
            }
            this.gen.genTimeWindowException(null, null, (byte)5, params);
        }
        if (Math.abs(bootTime - engine.getEngineTime()) > this.getTimelinessWindow()) {
            if (logger.finerOn()) {
                logger.finer("handleTimeliness", "Invalid time: Received time: " + bootTime + ", Local engine time: " + engine.getEngineTime());
            }
            this.gen.genTimeWindowException(null, null, (byte)5, params);
        }
    }

    synchronized int getTimelinessWindow() {
        return this.timeWindow;
    }

    synchronized void setTimelinessWindow(int t) {
        this.timeWindow = t;
    }
}

