/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.usm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.usm.SnmpUsmAlgorithm;
import java.util.Enumeration;
import java.util.Hashtable;

public class SnmpUsmAlgorithmManager {
    private Hashtable algos = new Hashtable();
    private Hashtable algosOid = new Hashtable();
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpUsmAlgorithmManager");
    String dbgTag = "SnmpUsmAlgorithmManager";

    public String[] getManagedAlgorithms() {
        String[] res = new String[this.algos.size()];
        int i = 0;
        Enumeration e = this.algos.keys();
        while (e.hasMoreElements()) {
            String key;
            res[i] = key = (String)e.nextElement();
            ++i;
        }
        return res;
    }

    public void addAlgorithm(SnmpUsmAlgorithm a) {
        if (logger.finerOn()) {
            logger.finer("addAlgorithm", "algo name : " + a.getAlgorithm());
        }
        this.algos.put(a.getAlgorithm(), a);
        this.algosOid.put(a.getOid(), a);
    }

    public SnmpUsmAlgorithm removeAlgorithm(String name) {
        SnmpUsmAlgorithm algo = (SnmpUsmAlgorithm)this.algos.remove(name);
        if (algo != null) {
            this.algosOid.remove(algo.getOid());
        }
        return algo;
    }

    public SnmpUsmAlgorithm getAlgorithm(String name) {
        SnmpUsmAlgorithm algo;
        if (logger.finerOn()) {
            logger.finer("getAlgorithm", "algo name : " + name);
        }
        if ((algo = (SnmpUsmAlgorithm)this.algos.get(name)) == null) {
            algo = (SnmpUsmAlgorithm)this.algosOid.get(name);
        }
        return algo;
    }
}

