/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.usm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpPersistRowFile;
import com.sun.management.snmp.SnmpEngineId;
import com.sun.management.snmp.usm.SnmpUsmSecureUser;
import com.sun.management.snmp.usm.SnmpUsmSecureUserImpl;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

class LcdEngine {
    Hashtable users = new Hashtable();
    SnmpEngineId engineId = null;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "LcdEngine");

    LcdEngine(SnmpEngineId id) {
        this.engineId = id;
    }

    void storeUsers(SnmpEngineId local, FileWriter writer, SnmpPersistRowFile file) {
        Enumeration e = this.users.elements();
        while (e.hasMoreElements()) {
            SnmpUsmSecureUserImpl user = (SnmpUsmSecureUserImpl)e.nextElement();
            if (user.getStorageType() < 3) continue;
            try {
                file.write(writer, user.getConf() + "\n\n");
            }
            catch (IOException ex) {
                if (!logger.finestOn()) break;
                logger.finest("storeUsers", ex);
                break;
            }
        }
    }

    SnmpUsmSecureUser addSecureUser(SnmpUsmSecureUser user) {
        if (logger.finestOn()) {
            logger.finest("addSecureUser", " adding user :" + user.getName());
        }
        return this.users.put(user.getName(), user);
    }

    SnmpUsmSecureUser getSecureUser(String name) {
        return (SnmpUsmSecureUser)this.users.get(name);
    }

    SnmpUsmSecureUser removeSecureUser(String name) {
        return (SnmpUsmSecureUser)this.users.remove(name);
    }
}

