/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.manager.usm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpEngineImpl;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpEngineId;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpUnknownModelException;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.SnmpVarBindList;
import com.sun.management.snmp.manager.SnmpParams;
import com.sun.management.snmp.manager.SnmpPeer;
import com.sun.management.snmp.manager.SnmpRequest;
import com.sun.management.snmp.manager.SnmpSession;
import com.sun.management.snmp.manager.SnmpV3Parameters;
import com.sun.management.snmp.manager.usm.SnmpUsmParameters;
import com.sun.management.snmp.usm.SnmpUsm;
import com.sun.management.snmp.usm.SnmpUsmEnginePeer;
import com.sun.management.snmp.usm.SnmpUsmSecurityParameters;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class SnmpUsmPeer
extends SnmpPeer {
    private static final long serialVersionUID = -4395909104949922299L;
    SnmpUsmEnginePeer peer = null;
    SnmpEngineImpl engine = null;
    SnmpUsm model = null;
    private boolean authoritative = false;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpUsmPeer");
    String dbgTag = "SnmpUsmPeer";

    public SnmpUsmPeer(SnmpEngine engine, String host) throws UnknownHostException, SnmpUnknownModelException, SnmpStatusException {
        super(host);
        this.init(engine, null, true);
    }

    public SnmpUsmPeer(SnmpEngine engine, InetAddress netaddr) throws SnmpUnknownModelException, SnmpStatusException {
        super(netaddr);
        this.init(engine, null, true);
    }

    public SnmpUsmPeer(SnmpEngine engine, String host, int port) throws UnknownHostException, SnmpUnknownModelException, SnmpStatusException {
        super(host, port);
        this.init(engine, null, true);
    }

    public SnmpUsmPeer(SnmpEngine engine, String host, SnmpEngineId id) throws UnknownHostException, SnmpUnknownModelException, SnmpStatusException {
        super(host);
        if (id == null) {
            this.authoritative = true;
        }
        this.init(engine, id, false);
    }

    public SnmpUsmPeer(SnmpEngine engine, InetAddress netaddr, SnmpEngineId id) throws SnmpUnknownModelException, SnmpStatusException {
        super(netaddr);
        if (id == null) {
            this.authoritative = true;
        }
        this.init(engine, id, false);
    }

    public SnmpUsmPeer(SnmpEngine engine, String host, int port, SnmpEngineId id) throws UnknownHostException, SnmpUnknownModelException, SnmpStatusException {
        super(host, port);
        if (id == null) {
            this.authoritative = true;
        }
        this.init(engine, id, false);
    }

    private void init(SnmpEngine eng, SnmpEngineId id, boolean discovery) throws SnmpUnknownModelException, SnmpStatusException {
        this.engine = (SnmpEngineImpl)eng;
        this.model = (SnmpUsm)this.engine.getSecuritySubSystem().getModel(3);
        if (discovery) {
            this.processEngineIdDiscovery();
        } else {
            this.setEngineId(id);
        }
        if (this.engine.getEngineId().equals(this.getEngineId())) {
            if (logger.finerOn()) {
                logger.finer("init", "Warning, discovered engine id [" + this.getEngineId() + "] is equal to local one [" + this.engine.getEngineId() + "] \n");
            }
            throw new SnmpStatusException("Discovered engine id [ " + this.getEngineId() + "] is equal to local one [" + this.engine.getEngineId() + "]");
        }
    }

    public boolean isTimelinessSynchronized() {
        if (this.peer == null) {
            return false;
        }
        return this.peer.getAuthoritativeEngineBoots() != 0 || this.peer.getAuthoritativeEngineTime() != 0;
    }

    public boolean isAuthoritative() {
        return this.authoritative;
    }

    public int getEngineBoots() {
        if (this.peer == null) {
            return 0;
        }
        return this.peer.getAuthoritativeEngineBoots();
    }

    public int getEngineTime() {
        if (this.peer == null) {
            return 0;
        }
        return this.peer.getAuthoritativeEngineTime();
    }

    private void setEngineId(SnmpEngineId engineId) {
        if (engineId != null) {
            this.peer = this.model.getEnginePeer(engineId);
        }
    }

    public SnmpEngineId getEngineId() {
        if (this.peer == null) {
            return null;
        }
        return this.peer.getAuthoritativeEngineId();
    }

    public void processUsmTimelinessDiscovery() throws SnmpStatusException {
        if (this.peer == null) {
            throw new IllegalArgumentException("No engine Id, this peer can't be used for timeliness discovery.");
        }
        if (this.getParams() instanceof SnmpUsmParameters) {
            SnmpUsmParameters usm = (SnmpUsmParameters)this.getParams();
            if ((usm.getSecurityLevel() & 1) != 0) {
                if (usm.getPrincipal() != null) {
                    this.processUsmDiscovery(usm.getPrincipal());
                    return;
                }
            } else {
                if (logger.finestOn()) {
                    logger.finest("processUsmTimelinessDiscovery", "Discovery must be done in an authenticated way.");
                }
                throw new SnmpStatusException(249, 0);
            }
        }
        if (logger.finestOn()) {
            logger.finest("processUsmTimelinessDiscovery", "Parameters are not SnmpUsmParameters. Can't process discovery");
        }
        throw new SnmpStatusException("Parameters are not SnmpUsmParameters. Can't process discovery");
    }

    public void setParams(SnmpParams p) {
        if (p instanceof SnmpUsmParameters) {
            SnmpUsmParameters usm = (SnmpUsmParameters)p;
            usm.setEngineId(this.getEngineId());
        }
        super.setParams(p);
    }

    SnmpUsm getSecurityModel() {
        return this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEngineIdDiscovery() throws SnmpStatusException {
        SnmpParams current = null;
        SnmpSession discoverySession = null;
        if (this.peer == null) {
            try {
                current = this.getParams();
                SnmpUsmParameters v3params = null;
                try {
                    v3params = new SnmpUsmParameters(this.engine);
                }
                catch (SnmpUnknownModelException e) {
                    if (logger.finerOn()) {
                        logger.finer("processEngineIdDiscovery", "Failed " + e);
                    }
                    this.setParams(current);
                    discoverySession.destroySession();
                    return;
                }
                SnmpUsmSecurityParameters usmp = (SnmpUsmSecurityParameters)v3params.getSecurityParameters();
                this.setParams(v3params);
                discoverySession = new SnmpSession(this.engine, "Discovery session", this);
                this.discoverEngineId(discoverySession, v3params);
                if (logger.finerOn()) {
                    logger.finer("processEngineIdDiscovery", "Engine Id : " + this.getEngineId());
                }
            }
            finally {
                this.setParams(current);
                discoverySession.destroySession();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUsmDiscovery(String principal) throws SnmpStatusException {
        SnmpParams current = this.getParams();
        SnmpUsmParameters v3params = null;
        try {
            v3params = new SnmpUsmParameters(this.engine, principal);
        }
        catch (SnmpUnknownModelException e) {
            if (logger.finerOn()) {
                logger.finer("processUsmDiscovery", "Failed. Can't happen." + e);
            }
            return;
        }
        SnmpUsmSecurityParameters usmp = (SnmpUsmSecurityParameters)v3params.getSecurityParameters();
        this.setParams(v3params);
        SnmpSession discoverySession = new SnmpSession(this.engine, "Discovery session", this);
        try {
            if (this.peer == null) {
                this.discoverEngineId(discoverySession, v3params);
            } else {
                this.peer.reset();
            }
            usmp.setAuthoritativeEngineId(this.getEngineId());
            this.discoverTimelinessParams(discoverySession, v3params);
            if (logger.finerOn()) {
                logger.finer("processUsmDiscovery", "Result :\nEngine Id : " + this.getEngineId() + "\n" + "Engine nb boots : " + this.getEngineBoots() + "\n" + "Engine time : " + this.getEngineTime());
            }
        }
        finally {
            this.setParams(current);
            discoverySession.destroySession();
        }
    }

    private void discoverEngineId(SnmpSession discoverySession, SnmpV3Parameters v3params) throws SnmpStatusException {
        SnmpVarBindList l = new SnmpVarBindList();
        SnmpUsmSecurityParameters secParams = (SnmpUsmSecurityParameters)v3params.getSecurityParameters();
        secParams.setAuthoritativeEngineBoots(0);
        secParams.setAuthoritativeEngineTime(0);
        v3params.setSecurityLevel(0);
        SnmpRequest req = discoverySession.snmpGetRequest(this, null, l);
        boolean completed = req.waitForCompletion(this.getTimeout());
        if (!completed || req.getErrorStatus() != 0 || !req.isReport()) {
            if (logger.finestOn()) {
                logger.finest("discoverEngineId", "An error occurred when processing Engine discovery. Request status : " + SnmpRequest.snmpErrorToString(req.getErrorStatus()));
            }
            if (req.getErrorStatus() == 247 && logger.finestOn()) {
                logger.finest("discoverEngineId", "The received engine Id is invalid or is equal to the local one.");
            }
            throw new SnmpStatusException(req.getErrorStatus());
        }
        SnmpUsmSecurityParameters usmp = (SnmpUsmSecurityParameters)req.getResponseSecurityParameters();
        this.setEngineId(usmp.getAuthoritativeEngineId());
        if (logger.finestOn()) {
            logger.finest("discoverEngineId", "Result :\nEngine Id : " + this.getEngineId());
        }
    }

    private void discoverTimelinessParams(SnmpSession discoverySession, SnmpV3Parameters v3params) throws SnmpStatusException {
        SnmpVarBindList l = new SnmpVarBindList();
        SnmpUsmSecurityParameters secParams = (SnmpUsmSecurityParameters)v3params.getSecurityParameters();
        secParams.setAuthoritativeEngineBoots(0);
        secParams.setAuthoritativeEngineTime(0);
        v3params.setSecurityLevel(1);
        SnmpRequest req = discoverySession.snmpGetRequest(this, null, l);
        boolean completed = req.waitForCompletion(this.getTimeout());
        if (!completed || req.getErrorStatus() != 0 || !req.isReport()) {
            if (logger.finestOn()) {
                logger.finest("discoverTimelinessParams", "An error occurred when processing Engine discovery. Request status : " + SnmpRequest.snmpErrorToString(req.getErrorStatus()));
            }
            throw new SnmpStatusException(req.getErrorStatus());
        }
        if (req.isReport()) {
            SnmpVarBind var;
            SnmpOid o;
            SnmpOid oid;
            SnmpVarBindList list = req.getReportVarBindList();
            if (list.size() == 0) {
                throw new SnmpStatusException("Received an empty report");
            }
            if (logger.finestOn()) {
                logger.finest("discoverTimelinessParams", "Received a report, list size is : " + list.size());
            }
            if ((oid = new SnmpOid("1.3.6.1.6.3.15.1.1.2.0")).equals(o = (var = list.getVarBindAt(0)).getOid())) {
                if (logger.finestOn()) {
                    logger.finest("discoverTimelinessParams", "Received a notInTimeWindow report. Discovery suceeded.");
                }
            } else {
                throw new SnmpStatusException("An error occurred when processing Engine discovery. Not received the right report : " + o + ". Expected notInTimeWindow [1.3.6.1.6.3.15.1.1.2.0]");
            }
        }
        if (logger.finestOn()) {
            logger.finest("discoverTimelinessParams", "Result :\nEngine nb boots : " + this.getEngineBoots() + "\n" + "Engine time : " + this.getEngineTime());
        }
    }
}

