/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.manager;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.JdmkEngineFactory;
import com.sun.management.snmp.SnmpDefinitions;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpEngineFactory;
import com.sun.management.snmp.SnmpEngineId;
import com.sun.management.snmp.SnmpEngineParameters;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpPduFactory;
import com.sun.management.snmp.SnmpPduFactoryBER;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpTimeticks;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.SnmpVarBindList;
import com.sun.management.snmp.manager.SnmpOptions;
import com.sun.management.snmp.manager.SnmpPeer;
import com.sun.management.snmp.manager.SnmpPollRequest;
import com.sun.management.snmp.manager.SnmpQManager;
import com.sun.management.snmp.manager.SnmpRequest;
import com.sun.management.snmp.manager.SnmpRequestHandler;
import com.sun.management.snmp.manager.SnmpResponseHandler;
import com.sun.management.snmp.manager.SnmpSocket;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;

public class SnmpSession
implements SnmpDefinitions,
Runnable,
Serializable {
    private static final long serialVersionUID = 1695304966953152644L;
    private SnmpEngine engine = null;
    private SnmpPduFactory pduFactory = new SnmpPduFactoryBER();
    private boolean hide = true;
    String usedThread = null;
    SnmpResponseHandler snmpRespHdlr = null;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpSession");
    private boolean isBeingDestroyed = false;
    private Thread _myThread = null;
    private Stack _respq = new Stack();
    private SnmpSocket _theSocket = null;
    private SnmpPeer _defaultPeer = null;
    private SnmpRequest _syncReq;
    public String sessionName;
    private Hashtable _requestList = new Hashtable();
    public SnmpOptions snmpOptions = new SnmpOptions();
    private static final SnmpOid sysUpTimeOid = new SnmpOid("1.3.6.1.2.1.1.3.0");
    private static final SnmpOid snmpTrapOidOid = new SnmpOid("1.3.6.1.6.3.1.1.4.1.0");
    private transient long startUpTime = 0L;
    SnmpQManager snmpQman = null;
    String dbgTag = "SnmpSession";

    public SnmpSession(SnmpEngine engine, String name, SnmpPeer apeer) throws SnmpStatusException, IllegalArgumentException {
        if (engine == null) {
            throw new IllegalArgumentException("Engine can't be null");
        }
        this.engine = engine;
        this.initialize(name, apeer, null, 0);
    }

    public SnmpSession(String name, SnmpPeer apeer) throws SnmpStatusException, IllegalArgumentException {
        this(new SnmpEngineParameters(), new JdmkEngineFactory(), name, apeer);
    }

    public SnmpSession(String name) throws SnmpStatusException, IllegalArgumentException {
        this(new SnmpEngineParameters(), new JdmkEngineFactory(), name, null);
    }

    public SnmpSession(SnmpEngineParameters parameters, SnmpEngineFactory factory, String name, SnmpPeer apeer) throws SnmpStatusException, IllegalArgumentException {
        this(parameters, factory, name, apeer, null, 0);
    }

    public SnmpSession(SnmpEngineParameters parameters, SnmpEngineFactory factory, String name, SnmpPeer apeer, InetSocketAddress localaddress) throws SnmpStatusException, IllegalArgumentException {
        this(parameters, factory, name, apeer, localaddress == null ? null : localaddress.getAddress(), localaddress == null ? 0 : localaddress.getPort());
    }

    public SnmpSession(SnmpEngineParameters parameters, SnmpEngineFactory factory, String name, SnmpPeer apeer, InetAddress localaddress, int port) throws SnmpStatusException, IllegalArgumentException {
        if (factory == null) {
            factory = new JdmkEngineFactory();
        }
        if (parameters == null) {
            parameters = new SnmpEngineParameters();
        }
        this.engine = factory.createEngine(parameters);
        this.initialize(name, apeer, localaddress, port);
    }

    public SnmpEngine getEngine() {
        return this.engine;
    }

    public final String getName() {
        return this.sessionName;
    }

    public final SnmpPduFactory getPduFactory() {
        return this.pduFactory;
    }

    public final synchronized void setPduFactory(SnmpPduFactory factory) {
        if (factory == null) {
            factory = new SnmpPduFactoryBER();
        }
        this.pduFactory = factory;
    }

    public synchronized void hideInvalidResponseError(boolean hide) {
        this.hide = hide;
    }

    public synchronized boolean isInvalidResponseErrorHidden() {
        return this.hide;
    }

    public final void setName(String name) {
        if (name == null) {
            name = "UnnamedSession";
        } else {
            this.sessionName = name;
        }
    }

    public final SnmpPeer getDefaultPeer() {
        return this._defaultPeer;
    }

    public final void setDefaultPeer(SnmpPeer apeer) {
        this._defaultPeer = apeer;
    }

    public final synchronized SnmpEngineId getEngineId() {
        return this.engine.getEngineId();
    }

    public final int getResponsePktSize() {
        return this._theSocket.getResponsePktSize();
    }

    public final void setResponsePktSize(int size) {
        this._theSocket.setResponsePktSize(size);
    }

    public final synchronized int getPktsErrors() {
        return this._theSocket.getPktsErrors();
    }

    public final synchronized int getInPkts() {
        return this._theSocket.getInPkts();
    }

    public final synchronized int getOutPkts() {
        return this._theSocket.getOutPkts();
    }

    public final synchronized void performResetPktStatistics() {
        this._theSocket.performResetPktStatistics();
    }

    public final String toString() {
        return "SnmpSession : " + this.sessionName;
    }

    final SnmpSocket getSocket() {
        return this._theSocket;
    }

    final void setSocket(SnmpSocket socket) throws SocketException {
        if (!socket.isValid()) {
            throw new SocketException("Cannot set an invalid socket.");
        }
        this._theSocket = socket;
    }

    final synchronized boolean isEquivalent(SnmpSession arg) {
        return this == arg;
    }

    public final synchronized boolean isSessionActive() {
        return this._myThread != null && this._myThread.isAlive();
    }

    public synchronized boolean syncInProgress() {
        return this._syncReq != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroySession() {
        this.isBeingDestroyed = true;
        this._theSocket.isBeingDestroyed = true;
        this.cancelAllRequests();
        this.cancelAllResponses();
        SnmpSession snmpSession = this;
        synchronized (snmpSession) {
            this._theSocket.close();
            this._theSocket = null;
        }
        SnmpSession snmpSession2 = this;
        snmpSession2.snmpQman.decNbSessions();
        this.killSessionThread();
    }

    public synchronized Vector getAllRequestsForPeer(SnmpPeer apeer) {
        Vector<SnmpRequest> vec = new Vector<SnmpRequest>();
        Enumeration e = this._requestList.elements();
        while (e.hasMoreElements()) {
            SnmpRequest req = (SnmpRequest)e.nextElement();
            if (req.getPeer() != apeer) continue;
            vec.addElement(req);
        }
        return vec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancelAllRequests() {
        SnmpRequest[] list;
        SnmpSession snmpSession = this;
        synchronized (snmpSession) {
            if (this._requestList.isEmpty()) {
                return;
            }
            list = new SnmpRequest[this._requestList.size()];
            Iterator it = this._requestList.values().iterator();
            int i = 0;
            while (it.hasNext()) {
                SnmpRequest req = (SnmpRequest)it.next();
                list[i++] = req;
                it.remove();
            }
            this._requestList.clear();
        }
        for (int i = 0; i < list.length; ++i) {
            list[i].cancelRequest();
        }
    }

    public boolean checkResponseFor(SnmpRequest req) {
        return this._respq.contains(req);
    }

    public boolean thisSessionContext() {
        return Thread.currentThread() == this.getDispatcher();
    }

    public final SnmpRequest snmpGetRequest(SnmpPeer peer, SnmpRequestHandler cb, SnmpVarBindList vblst) throws SnmpStatusException {
        return this.makeAsyncRequest(this.definePeer(peer), 160, cb, vblst);
    }

    public final SnmpRequest snmpGetRequest(SnmpRequestHandler cb, SnmpVarBindList vblst) throws SnmpStatusException {
        return this.snmpGetRequest(this._defaultPeer, cb, vblst);
    }

    public final SnmpRequest snmpGetNextRequest(SnmpPeer peer, SnmpRequestHandler cb, SnmpVarBindList vblst) throws SnmpStatusException {
        return this.makeAsyncRequest(this.definePeer(peer), 161, cb, vblst);
    }

    public final SnmpRequest snmpGetNextRequest(SnmpRequestHandler cb, SnmpVarBindList vblst) throws SnmpStatusException {
        return this.snmpGetNextRequest(this._defaultPeer, cb, vblst);
    }

    public final SnmpRequest snmpGetBulkRequest(SnmpPeer peer, SnmpRequestHandler cb, SnmpVarBindList vblst, int nonRepeat, int maxRepeat) throws SnmpStatusException {
        return this.makeAsyncBulkRequest(this.definePeer(peer), cb, vblst, nonRepeat, maxRepeat);
    }

    public final SnmpRequest snmpGetBulkRequest(SnmpRequestHandler cb, SnmpVarBindList vblst, int nonRepeat, int maxRepeat) throws SnmpStatusException {
        return this.snmpGetBulkRequest(this._defaultPeer, cb, vblst, nonRepeat, maxRepeat);
    }

    public final SnmpRequest snmpSetRequest(SnmpPeer peer, SnmpRequestHandler cb, SnmpVarBindList vblst) throws SnmpStatusException {
        SnmpPeer p = this.definePeer(peer);
        if (vblst.isEmpty()) {
            throw new SnmpStatusException("VarBindList is empty for SNMP Set.");
        }
        if (!p.allowSnmpSets()) {
            throw new SnmpStatusException("Parameters may not have been configured for doing SNMP SET's.");
        }
        if (!vblst.checkForValidValues()) {
            throw new SnmpStatusException("One or more variable binding has no valid value.");
        }
        return this.makeAsyncRequest(p, 163, cb, vblst);
    }

    public final SnmpRequest snmpSetRequest(SnmpRequestHandler cb, SnmpVarBindList vblst) throws SnmpStatusException {
        return this.snmpSetRequest(this._defaultPeer, cb, vblst);
    }

    public final SnmpRequest snmpGetPollRequest(SnmpPeer peer, SnmpRequestHandler cb, SnmpVarBindList vblst, int intrvl) throws SnmpStatusException {
        return this.makeAsyncPollRequest(this.definePeer(peer), 160, cb, intrvl, vblst);
    }

    public final SnmpRequest snmpGetPollRequest(SnmpRequestHandler cb, SnmpVarBindList vblst, int intrvl) throws SnmpStatusException {
        return this.snmpGetPollRequest(this._defaultPeer, cb, vblst, intrvl);
    }

    public final SnmpRequest snmpGetNextPollRequest(SnmpPeer peer, SnmpRequestHandler cb, SnmpVarBindList vblst, int intrvl) throws SnmpStatusException {
        return this.makeAsyncPollRequest(this.definePeer(peer), 161, cb, intrvl, vblst);
    }

    public final SnmpRequest snmpGetNextPollRequest(SnmpRequestHandler cb, SnmpVarBindList vblst, int intrvl) throws SnmpStatusException {
        return this.snmpGetNextPollRequest(this._defaultPeer, cb, vblst, intrvl);
    }

    public final SnmpRequest snmpInformRequest(SnmpPeer peer, SnmpRequestHandler cb, SnmpOid trapOid, SnmpVarBindList vblst) throws SnmpStatusException {
        SnmpVarBindList fullVbl = vblst != null ? (SnmpVarBindList)vblst.clone() : new SnmpVarBindList();
        SnmpTimeticks sysUpTimeValue = new SnmpTimeticks(this.getSysUpTime());
        fullVbl.insertElementAt(new SnmpVarBind(snmpTrapOidOid, trapOid), 0);
        fullVbl.insertElementAt(new SnmpVarBind(sysUpTimeOid, sysUpTimeValue), 0);
        return this.makeAsyncRequest(this.definePeer(peer), 166, cb, fullVbl);
    }

    public final SnmpRequest snmpInformRequest(SnmpRequestHandler cb, SnmpOid trapOid, SnmpVarBindList vblst) throws SnmpStatusException {
        return this.snmpInformRequest(this._defaultPeer, cb, trapOid, vblst);
    }

    public final SnmpRequest snmpWalkUntilRequest(SnmpPeer peer, SnmpRequestHandler cb, SnmpVarBindList vblst, SnmpOid key) throws SnmpStatusException {
        if (!this.isSessionActive()) {
            throw new SnmpStatusException(this.sessionName + " : Session is dead...");
        }
        SnmpPollRequest snmpreq = new SnmpPollRequest(this, this.definePeer(peer), cb, 253);
        snmpreq.setOptions(this.snmpOptions.getOptions());
        snmpreq.startPoll(vblst, key, true, 0);
        return snmpreq;
    }

    public final SnmpRequest snmpWalkUntilRequest(SnmpRequestHandler cb, SnmpVarBindList vblst, SnmpOid key) throws SnmpStatusException {
        return this.snmpWalkUntilRequest(this._defaultPeer, cb, vblst, key);
    }

    final synchronized void addRequest(SnmpRequest reqc) throws SnmpStatusException {
        if (this.isBeingDestroyed) {
            return;
        }
        if (!this.isSessionActive()) {
            throw new SnmpStatusException(this.sessionName + " : Session is dead...");
        }
        this._requestList.put(reqc, reqc);
    }

    final synchronized void deleteRequest(SnmpRequest snmpreq) {
        if (!this.isBeingDestroyed) {
            this._requestList.remove(snmpreq);
        }
        if (this._syncReq != null && this._syncReq == snmpreq) {
            this.resetSyncMode();
        }
    }

    private synchronized void setSyncMode(SnmpRequest req) {
        this._syncReq = req;
    }

    private synchronized void resetSyncMode() {
        if (this._syncReq == null) {
            return;
        }
        this._syncReq = null;
        if (this.thisSessionContext()) {
            return;
        }
        this.notifyAll();
    }

    private SnmpPeer definePeer(SnmpPeer peer) throws IllegalArgumentException {
        if (peer == null) {
            peer = this.getDefaultPeer();
        }
        if (peer != null) {
            return peer;
        }
        throw new IllegalArgumentException("No SnmpPeer to process the request");
    }

    final SnmpRequest makeAsyncRequest(SnmpPeer peer, int cmd, SnmpRequestHandler cb, SnmpVarBindList vblst) throws SnmpStatusException {
        if (!this.isSessionActive()) {
            throw new SnmpStatusException(this.sessionName + " : Session is dead...");
        }
        SnmpRequest snmpreq = new SnmpRequest(this, peer, cb, cmd);
        snmpreq.setOptions(this.snmpOptions.getOptions());
        snmpreq.start(vblst, true, 0L);
        return snmpreq;
    }

    final SnmpRequest makeAsyncBulkRequest(SnmpPeer peer, SnmpRequestHandler cb, SnmpVarBindList vblst, int nonRepeat, int maxRepeat) throws SnmpStatusException {
        if (!this.isSessionActive()) {
            throw new SnmpStatusException(this.sessionName + " : Session is dead...");
        }
        SnmpRequest snmpreq = new SnmpRequest(this, peer, cb, nonRepeat, maxRepeat);
        snmpreq.setOptions(this.snmpOptions.getOptions());
        snmpreq.start(vblst, true, 0L);
        return snmpreq;
    }

    final SnmpPollRequest makeAsyncPollRequest(SnmpPeer peer, int cmd, SnmpRequestHandler cb, int intrvl, SnmpVarBindList vblst) throws SnmpStatusException {
        if (!this.isSessionActive()) {
            throw new SnmpStatusException(this.sessionName + " : Session is dead...");
        }
        SnmpPollRequest snmpreq = new SnmpPollRequest(this, peer, cb, cmd);
        snmpreq.setPollFrequency(intrvl);
        snmpreq.setOptions(this.snmpOptions.getOptions());
        snmpreq.startPoll(vblst, true, 0);
        return snmpreq;
    }

    public boolean anyPendingResponses() {
        return !this._respq.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        SnmpSession snmpSession = this;
        synchronized (snmpSession) {
            if (this._myThread == null) {
                return;
            }
            this._myThread = Thread.currentThread();
            this.usedThread = this._myThread.toString();
            this._myThread.setPriority(5);
        }
        SnmpRequest reqc = null;
        while (true) {
            SnmpSession snmpSession2 = this;
            synchronized (snmpSession2) {
                if (this._myThread == null) {
                    break;
                }
                try {
                    reqc = this.nextResponse(0L);
                }
                catch (ThreadDeath d) {
                    this._myThread = null;
                    if (logger.finestOn()) {
                        logger.finest("run", "Session thread unexpectedly shutting down " + this.sessionName);
                    }
                    throw d;
                }
            }
            if (reqc == null) continue;
            this.processResponse(reqc);
        }
        if (logger.finerOn()) {
            logger.finer("run", "Session thread shutting down " + this.sessionName);
        }
        this._myThread = null;
    }

    private void processResponse(SnmpRequest reqc) {
        while (reqc != null && this._myThread != null) {
            try {
                if (reqc == null) continue;
                if (logger.finerOn()) {
                    logger.finer("processResponse", "Processing response to req = " + reqc.getRequestId());
                }
                reqc.processResponse();
                reqc = null;
            }
            catch (Exception e) {
                if (logger.finestOn()) {
                    logger.finest("processResponse", e);
                }
                reqc = null;
            }
            catch (OutOfMemoryError ome) {
                if (logger.finestOn()) {
                    logger.finest("processResponse", "Out of memory error in session thread " + this.sessionName);
                    logger.finest("processResponse", ome);
                }
                Thread.currentThread();
                Thread.yield();
            }
        }
    }

    public void finalize() {
        if (this._respq != null) {
            this._respq.removeAllElements();
        }
        this._respq = null;
        if (this._theSocket != null) {
            this._theSocket.close();
        }
        this._theSocket = null;
        if (logger.finerOn()) {
            logger.finer("finalize", "Shutting all servers");
        }
        this.snmpQman = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForResponse(SnmpRequest req, long waitTime) {
        if (!req.inProgress()) {
            return;
        }
        this.setSyncMode(req);
        if (logger.finerOn()) {
            logger.finer("waitForResponse", "Session switching to sync mode for request " + req.getRequestId());
        }
        long maxTime = waitTime <= 0L ? System.currentTimeMillis() + 6000000L : System.currentTimeMillis() + waitTime;
        while ((req.inProgress() || this.syncInProgress()) && (waitTime = maxTime - System.currentTimeMillis()) > 0L) {
            SnmpSession snmpSession = this;
            synchronized (snmpSession) {
                if (!this._respq.removeElement(req)) {
                    try {
                        this.wait(waitTime);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    continue;
                }
            }
            try {
                this.processResponse(req);
            }
            catch (Exception e) {
                if (!logger.finestOn()) continue;
                logger.finest("waitForResponse", e);
            }
        }
        this.resetSyncMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addResponse(SnmpRequest reqc) {
        if (this.isBeingDestroyed) {
            return;
        }
        SnmpRequest snmpreq = reqc;
        if (this.isSessionActive()) {
            if (this.syncInProgress() && (snmpreq = reqc).isInternalRequest()) {
                if (logger.finerOn()) {
                    logger.finer("addResponse", "Session in sync mode. processing internal request only: " + reqc.getRequestId());
                }
                this.processResponse(reqc);
                return;
            }
            SnmpSession snmpSession = this;
            synchronized (snmpSession) {
                this._respq.push(reqc);
                this.notifyAll();
            }
        } else if (logger.finestOn()) {
            logger.finest("addResponse", "Peer thread dead. So response is dropped..." + reqc.getRequestId());
        }
    }

    private synchronized void cancelAllResponses() {
        if (this._respq != null) {
            this._syncReq = null;
            this._respq.removeAllElements();
            this.notifyAll();
        }
    }

    private final Thread getDispatcher() {
        return this._myThread;
    }

    private synchronized void initialize(String name, SnmpPeer apeer, InetAddress addr, int port) throws SnmpStatusException, IllegalArgumentException {
        if (this.engine == null) {
            throw new IllegalArgumentException("The factory returned a null lengine. SnmpSession initilization failed");
        }
        this._defaultPeer = apeer;
        this.sessionName = name;
        if (logger.finerOn()) {
            logger.finer("initialize", "Initializing SNMP session internals");
        }
        if (this._theSocket == null) {
            this.snmpQman = SnmpQManager.incNbSessions();
            this.snmpRespHdlr = new SnmpResponseHandler(this.snmpQman, this);
            this.snmpRespHdlr.setEngine(this.engine);
            try {
                SnmpSocket asocket = new SnmpSocket(this.snmpRespHdlr, addr, port);
                this.setSocket(asocket);
            }
            catch (SocketException se) {
                if (logger.finestOn()) {
                    logger.finest("initialize", "Unable to initialize Snmp Datagram socket");
                    logger.finest("initialize", se);
                }
                throw new SnmpStatusException("Unable to initialize Snmp Datagram Socket");
            }
        }
        if (this._myThread == null) {
            this._myThread = new Thread(this);
        }
        if (!this._myThread.isAlive()) {
            this._myThread.start();
        }
        this.startUpTime = System.currentTimeMillis();
        if (logger.finerOn()) {
            logger.finer("initialize", "SNMP session internals initialized OK");
        }
    }

    synchronized SnmpRequest nextResponse(long time) {
        if (this._respq.isEmpty()) {
            try {
                if (logger.finerOn()) {
                    logger.finer("nextResponse", "Blocking for response");
                }
                this.wait(time);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (this._respq.isEmpty()) {
            return null;
        }
        SnmpRequest reqc = (SnmpRequest)this._respq.firstElement();
        this._respq.removeElementAt(0);
        return reqc;
    }

    private synchronized void killSessionThread() {
        if (this.isSessionActive()) {
            if (logger.finerOn()) {
                logger.finer("killSessionThread", "Destroying session " + this.sessionName);
            }
            if (Thread.currentThread() != this._myThread) {
                this._myThread = null;
                this.notifyAll();
            } else {
                this._myThread = null;
            }
        }
    }

    private long getSysUpTime() {
        return (System.currentTimeMillis() - this.startUpTime) / 10L;
    }
}

