/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.agent;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpEngineId;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpScopedPduPacket;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpUnknownModelException;
import com.sun.management.snmp.SnmpVarBindList;
import com.sun.management.snmp.agent.SnmpV3Proxy;
import com.sun.management.snmp.manager.SnmpParams;
import com.sun.management.snmp.manager.SnmpRequest;
import com.sun.management.snmp.manager.usm.SnmpUsmParameters;
import com.sun.management.snmp.manager.usm.SnmpUsmPeer;

public class SnmpUsmProxy
extends SnmpV3Proxy {
    private static final long serialVersionUID = -6442234160949252976L;
    String user = null;
    boolean timelinessRetry = true;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.proxy", "SnmpUsmProxy");
    String dbgTag = "SnmpUsmProxy";

    public SnmpUsmProxy(SnmpEngine engine, SnmpUsmPeer peer, String rootOid) throws SnmpStatusException {
        super(engine, peer, rootOid, "SnmpUsmProxy");
    }

    public SnmpUsmProxy(SnmpEngine engine, SnmpUsmPeer peer, String rootOid, String name) throws SnmpStatusException {
        super(engine, peer, rootOid, name);
    }

    public SnmpEngineId getEngineId() {
        return ((SnmpUsmPeer)this.getPeer()).getEngineId();
    }

    public void resyncOnTimelinessReport(boolean retry) {
        this.timelinessRetry = retry;
    }

    protected boolean handleReport(SnmpRequest request) {
        if (logger.finestOn()) {
            logger.finest("handleReport", "Received a report");
        }
        if (!this.timelinessRetry) {
            if (logger.finestOn()) {
                logger.finest("handleReport", "No retrying, return false");
            }
            return false;
        }
        SnmpVarBindList vbl = request.getReportVarBindList();
        SnmpOid notInTime = null;
        try {
            notInTime = new SnmpOid("1.3.6.1.6.3.15.1.1.2.0");
        }
        catch (Exception e) {
            return false;
        }
        if (vbl.indexOfOid(notInTime) != -1) {
            if (logger.finestOn()) {
                logger.finest("handleReport", "Received a Not in Time Window report");
            }
            SnmpUsmPeer peer = (SnmpUsmPeer)request.getPeer();
            try {
                peer.processUsmTimelinessDiscovery();
                if (logger.finestOn()) {
                    logger.finest("handleReport", " synchro done. EngineId : " + peer.getEngineId() + " time : " + peer.getEngineTime() + " boot : " + peer.getEngineBoots());
                }
            }
            catch (SnmpStatusException e) {
                if (logger.finestOn()) {
                    logger.finest("handleReport", "Time Window synchro failed.");
                }
                return false;
            }
            return true;
        }
        if (logger.finestOn()) {
            logger.finest("handleReport", "Received a report that is not usmStatsNotInTimeWindows");
        }
        return false;
    }

    protected final SnmpParams createParameters(SnmpPdu pdu) throws SnmpStatusException {
        SnmpUsmPeer p = (SnmpUsmPeer)this.getPeer();
        if (pdu == null || !(pdu instanceof SnmpScopedPduPacket)) {
            if (logger.finestOn()) {
                logger.finest("createParameters", "pdu :" + pdu);
            }
            return p.getParams();
        }
        SnmpScopedPduPacket pack = (SnmpScopedPduPacket)pdu;
        if (logger.finestOn()) {
            logger.finest("createParameters", "pdu security parameters :" + pack.securityParameters);
        }
        String principal = pack.securityParameters.getPrincipal();
        if (logger.finestOn()) {
            logger.finest("createParameters", "pdu principal :" + principal);
        }
        SnmpUsmParameters pa = null;
        try {
            pa = new SnmpUsmParameters(this.getEngine(), principal);
        }
        catch (SnmpUnknownModelException e) {
            if (logger.finerOn()) {
                logger.finer("createParameters", "Failed " + e);
            }
            throw new SnmpStatusException(e.toString());
        }
        pa.setContextEngineId(p.getEngineId().getBytes());
        return pa;
    }
}

