/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.agent;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.agent.SnmpMibSubRequest;
import com.sun.management.snmp.agent.SnmpStandardMetaServer;
import java.io.Serializable;
import java.util.Enumeration;

public class SnmpStandardObjectServer
implements Serializable {
    private static final long serialVersionUID = 3852945352578498555L;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpStandardObjectServer");

    public void get(SnmpStandardMetaServer meta, SnmpMibSubRequest req, int depth) throws SnmpStatusException {
        boolean finest = logger.finestOn();
        if (finest) {
            logger.finest("get", "getting instance: " + req.getEntryOid());
        }
        Object data = req.getUserData();
        Enumeration e = req.getElements();
        while (e.hasMoreElements()) {
            SnmpVarBind var = (SnmpVarBind)e.nextElement();
            try {
                long id = var.getOid().getOidArc(depth);
                if (finest) {
                    logger.finest("get", "getting column #" + id);
                }
                var.setSnmpValue(meta.get(id, data));
            }
            catch (SnmpStatusException x) {
                if (finest) {
                    logger.finest("get", "failed to get columnar data: " + x, x);
                }
                req.registerGetException(var, x);
            }
        }
    }

    public void set(SnmpStandardMetaServer meta, SnmpMibSubRequest req, int depth) throws SnmpStatusException {
        Object data = req.getUserData();
        Enumeration e = req.getElements();
        while (e.hasMoreElements()) {
            SnmpVarBind var = null;
            var = (SnmpVarBind)e.nextElement();
            try {
                long id = var.getOid().getOidArc(depth);
                var.setSnmpValue(meta.set(var.getSnmpValue(), id, data));
            }
            catch (SnmpStatusException x) {
                req.registerSetException(var, x);
            }
        }
    }

    public void check(SnmpStandardMetaServer meta, SnmpMibSubRequest req, int depth) throws SnmpStatusException {
        Object data = req.getUserData();
        Enumeration e = req.getElements();
        while (e.hasMoreElements()) {
            SnmpVarBind var = (SnmpVarBind)e.nextElement();
            try {
                long id = var.getOid().getOidArc(depth);
                meta.check(var.getSnmpValue(), id, data);
            }
            catch (SnmpStatusException x) {
                req.registerCheckException(var, x);
            }
        }
    }
}

