/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.agent;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpAccessControlModel;
import com.sun.management.internal.snmp.SnmpEngineImpl;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpUnknownModelException;
import com.sun.management.snmp.agent.LongList;
import com.sun.management.snmp.agent.SnmpMibRequest;

class AcmChecker {
    SnmpAccessControlModel model;
    String principal;
    int securityLevel;
    int version;
    int pduType;
    int securityModel;
    byte[] contextName;
    SnmpEngineImpl engine;
    LongList l;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "AcmChecker");

    AcmChecker(SnmpMibRequest req) {
        block5: {
            this.model = null;
            this.principal = null;
            this.securityLevel = -1;
            this.version = -1;
            this.pduType = -1;
            this.securityModel = -1;
            this.contextName = null;
            this.engine = null;
            this.l = null;
            this.engine = (SnmpEngineImpl)req.getEngine();
            if (this.engine != null && this.engine.isCheckOidActivated()) {
                try {
                    if (logger.finestOn()) {
                        logger.finest("AcmChecker", " SNMP V3 Access Control to be done.");
                    }
                    this.model = (SnmpAccessControlModel)this.engine.getAccessControlSubSystem().getModel(3);
                    this.principal = req.getPrincipal();
                    this.securityLevel = req.getSecurityLevel();
                    this.pduType = req.getPdu().type;
                    this.version = req.getRequestPduVersion();
                    this.securityModel = req.getSecurityModel();
                    this.contextName = req.getAccessContextName();
                    this.l = new LongList();
                    if (logger.finestOn()) {
                        logger.finest("AcmChecker", "Will check oid for : principal : " + this.principal + ";securityLevel : " + this.securityLevel + ";pduType : " + this.pduType + ";version : " + this.version + ";securityModel : " + this.securityModel + ";contextName : " + (this.contextName == null ? null : new String(this.contextName)));
                    }
                }
                catch (SnmpUnknownModelException e) {
                    if (!logger.finestOn()) break block5;
                    logger.finest("AcmChecker", " Unknown Model, no ACM check.");
                }
            }
        }
    }

    void add(int index, long arc) {
        if (this.model != null) {
            this.l.add(index, arc);
        }
    }

    void remove(int index) {
        if (this.model != null) {
            this.l.remove(index);
        }
    }

    void add(int at, long[] src, int from, int count) {
        if (this.model != null) {
            this.l.add(at, src, from, count);
        }
    }

    void remove(int from, int count) {
        if (this.model != null) {
            this.l.remove(from, count);
        }
    }

    void checkCurrentOid() throws SnmpStatusException {
        if (this.model != null) {
            SnmpOid oid = new SnmpOid(this.l.toArray());
            if (logger.finestOn()) {
                logger.finest("check", " Checking access for : " + oid);
            }
            this.model.checkAccess(this.version, this.principal, this.securityLevel, this.pduType, this.securityModel, this.contextName, oid);
        }
    }
}

