/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp;

import com.sun.jdmk.tasks.Task;
import com.sun.jdmk.tasks.TaskServer;
import com.sun.management.snmp.JdmkEngineFactory;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpEngineFactory;
import com.sun.management.snmp.SnmpEngineParameters;
import java.net.InetAddress;
import java.net.SocketException;

public class SnmpEventReportDispatcher
extends com.sun.management.snmp.manager.SnmpEventReportDispatcher {
    private final TaskServer packetTaskServer;
    private final TaskServer callbackTaskServer;
    private static final String dbgTag = "SnmpEventReportDispatcher";

    public SnmpEventReportDispatcher() throws SocketException, IllegalArgumentException {
        this(new SnmpEngineParameters(), new JdmkEngineFactory(), 162, null, new DefaultTaskServer(), null);
    }

    public SnmpEventReportDispatcher(int portNumber) throws SocketException, IllegalArgumentException {
        this(new SnmpEngineParameters(), new JdmkEngineFactory(), portNumber, null, new DefaultTaskServer(), null);
    }

    public SnmpEventReportDispatcher(int portNumber, InetAddress address, TaskServer packetTaskServer, TaskServer callbackTaskServer) throws SocketException, IllegalArgumentException {
        this(new SnmpEngineParameters(), new JdmkEngineFactory(), portNumber, address, packetTaskServer, callbackTaskServer);
    }

    public SnmpEventReportDispatcher(SnmpEngineParameters parameters, SnmpEngineFactory factory, int portNumber, TaskServer packetTaskServer, TaskServer callbackTaskServer) throws SocketException, IllegalArgumentException {
        this(parameters, factory, portNumber, null, packetTaskServer, callbackTaskServer);
    }

    public SnmpEventReportDispatcher(SnmpEngine engine, int portNumber, TaskServer packetTaskServer, TaskServer callbackTaskServer) throws SocketException, IllegalArgumentException {
        this(engine, portNumber, null, packetTaskServer, callbackTaskServer);
    }

    public SnmpEventReportDispatcher(SnmpEngineParameters parameters, SnmpEngineFactory factory, int portNumber, InetAddress address, TaskServer packetTaskServer, TaskServer callbackTaskServer) throws SocketException, IllegalArgumentException {
        super(parameters, factory, portNumber, address);
        this.packetTaskServer = packetTaskServer;
        this.callbackTaskServer = callbackTaskServer;
    }

    public SnmpEventReportDispatcher(SnmpEngine engine, int portNumber, InetAddress address, TaskServer packetTaskServer, TaskServer callbackTaskServer) throws SocketException, IllegalArgumentException {
        super(engine, portNumber, address);
        this.packetTaskServer = packetTaskServer;
        this.callbackTaskServer = callbackTaskServer;
    }

    protected final void handleCallback(Runnable callbackHandler) {
        if (this.callbackTaskServer == null) {
            callbackHandler.run();
        } else {
            this.callbackTaskServer.submitTask(new TaskHandler(callbackHandler));
        }
    }

    protected final void handlePacket(Runnable packetHandler) {
        if (this.packetTaskServer == null) {
            packetHandler.run();
        } else {
            this.packetTaskServer.submitTask(new TaskHandler(packetHandler));
        }
    }

    private static final class DefaultTaskServer
    implements TaskServer {
        private DefaultTaskServer() {
        }

        public final void submitTask(Task task) {
            new Thread(task).start();
        }
    }

    private static final class TaskHandler
    implements Task {
        private final Runnable task;

        public TaskHandler(Runnable task) {
            this.task = task;
        }

        public void run() {
            if (this.task == null) {
                return;
            }
            this.task.run();
        }

        public void cancel() {
        }
    }
}

