/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.comm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.comm.SnmpAdaptorServer;
import com.sun.management.comm.SnmpInformRequest;
import com.sun.management.comm.SnmpQManager;
import com.sun.management.snmp.SnmpMessage;
import com.sun.management.snmp.SnmpPduFactory;
import com.sun.management.snmp.SnmpPduPacket;
import com.sun.management.snmp.SnmpPduRequest;
import java.net.DatagramPacket;

class SnmpResponseHandler {
    SnmpAdaptorServer adaptor = null;
    SnmpQManager snmpq = null;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.adaptor", "SnmpResponseHandler");

    public SnmpResponseHandler(SnmpAdaptorServer adp, SnmpQManager s) {
        this.adaptor = adp;
        this.snmpq = s;
    }

    public synchronized void processDatagram(DatagramPacket dgrm) {
        block15: {
            byte[] data = dgrm.getData();
            int datalen = dgrm.getLength();
            if (logger.finerOn()) {
                logger.finer("processDatagram", "Received from " + dgrm.getAddress().toString() + " Length = " + datalen + "\nDump : \n" + SnmpMessage.dumpHexBuffer(data, 0, datalen));
            }
            try {
                SnmpMessage msg = new SnmpMessage();
                msg.decodeMessage(data, datalen);
                msg.address = dgrm.getAddress();
                msg.port = dgrm.getPort();
                SnmpPduFactory pduFactory = this.adaptor.getPduFactory();
                if (pduFactory == null) {
                    if (logger.finestOn()) {
                        logger.finest("processDatagram", "Dropping packet. Unable to find the pdu factory of the SNMP adaptor server");
                    }
                } else {
                    SnmpPduPacket snmpProt = (SnmpPduPacket)pduFactory.decodeSnmpPdu(msg);
                    if (snmpProt == null) {
                        if (logger.finestOn()) {
                            logger.finest("processDatagram", "Dropping packet. Pdu factory returned a null value");
                        }
                    } else if (snmpProt instanceof SnmpPduRequest) {
                        SnmpPduRequest pduReq = (SnmpPduRequest)snmpProt;
                        SnmpInformRequest req = this.snmpq.removeRequest(pduReq.requestId);
                        if (req != null) {
                            req.invokeOnResponse(pduReq);
                        } else if (logger.finestOn()) {
                            logger.finest("processDatagram", "Dropping packet. Unable to find corresponding request for InformRequestId = " + pduReq.requestId);
                        }
                    } else if (logger.finestOn()) {
                        logger.finest("processDatagram", "Dropping packet. The packet does not contain an inform response");
                    }
                    snmpProt = null;
                }
            }
            catch (Exception e) {
                if (!logger.finestOn()) break block15;
                logger.finest("processDatagram", "Exception while processsing");
                logger.finest("processDatagram", e);
            }
        }
    }
}

