/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.cardinal.netconf.rev161227.cardinalnetconfinfogrouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.cardinal.netconf.rev161227.cardinalnetconfinfogrouping.Netconf;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NetconfBuilder
implements Builder<Netconf> {
    private String _host;
    private String _nodeId;
    private String _port;
    private String _status;
    Map<Class<? extends Augmentation<Netconf>>, Augmentation<Netconf>> augmentation = Collections.emptyMap();

    public NetconfBuilder() {
    }

    public NetconfBuilder(Netconf base) {
        AugmentationHolder casted;
        this._host = base.getHost();
        this._nodeId = base.getNodeId();
        this._port = base.getPort();
        this._status = base.getStatus();
        if (base instanceof NetconfImpl) {
            NetconfImpl impl = (NetconfImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Netconf>>, Augmentation<Netconf>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Netconf>>, Augmentation<Netconf>>(casted.augmentations());
        }
    }

    public String getHost() {
        return this._host;
    }

    public String getNodeId() {
        return this._nodeId;
    }

    public String getPort() {
        return this._port;
    }

    public String getStatus() {
        return this._status;
    }

    public <E extends Augmentation<Netconf>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NetconfBuilder setHost(String value) {
        this._host = value;
        return this;
    }

    public NetconfBuilder setNodeId(String value) {
        this._nodeId = value;
        return this;
    }

    public NetconfBuilder setPort(String value) {
        this._port = value;
        return this;
    }

    public NetconfBuilder setStatus(String value) {
        this._status = value;
        return this;
    }

    public NetconfBuilder addAugmentation(Class<? extends Augmentation<Netconf>> augmentationType, Augmentation<Netconf> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Netconf>>, Augmentation<Netconf>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NetconfBuilder removeAugmentation(Class<? extends Augmentation<Netconf>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Netconf build() {
        return new NetconfImpl(this);
    }

    private static final class NetconfImpl
    implements Netconf {
        private final String _host;
        private final String _nodeId;
        private final String _port;
        private final String _status;
        private Map<Class<? extends Augmentation<Netconf>>, Augmentation<Netconf>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Netconf> getImplementedInterface() {
            return Netconf.class;
        }

        private NetconfImpl(NetconfBuilder base) {
            this._host = base.getHost();
            this._nodeId = base.getNodeId();
            this._port = base.getPort();
            this._status = base.getStatus();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Netconf>>, Augmentation<Netconf>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Netconf>>, Augmentation<Netconf>>(base.augmentation);
                }
            }
        }

        @Override
        public String getHost() {
            return this._host;
        }

        @Override
        public String getNodeId() {
            return this._nodeId;
        }

        @Override
        public String getPort() {
            return this._port;
        }

        @Override
        public String getStatus() {
            return this._status;
        }

        public <E extends Augmentation<Netconf>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._host);
            result = 31 * result + Objects.hashCode(this._nodeId);
            result = 31 * result + Objects.hashCode(this._port);
            result = 31 * result + Objects.hashCode(this._status);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Netconf.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Netconf other = (Netconf)obj;
            if (!Objects.equals(this._host, other.getHost())) {
                return false;
            }
            if (!Objects.equals(this._nodeId, other.getNodeId())) {
                return false;
            }
            if (!Objects.equals(this._port, other.getPort())) {
                return false;
            }
            if (!Objects.equals(this._status, other.getStatus())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NetconfImpl otherImpl = (NetconfImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Netconf>>, Augmentation<Netconf>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Netconf [";
            StringBuilder builder = new StringBuilder(name);
            if (this._host != null) {
                builder.append("_host=");
                builder.append(this._host);
                builder.append(", ");
            }
            if (this._nodeId != null) {
                builder.append("_nodeId=");
                builder.append(this._nodeId);
                builder.append(", ");
            }
            if (this._port != null) {
                builder.append("_port=");
                builder.append(this._port);
                builder.append(", ");
            }
            if (this._status != null) {
                builder.append("_status=");
                builder.append(this._status);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

