/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.set.channel.input;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.set.channel.input.EgressNode;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.set.channel.input.EgressNodeKey;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.set.channel.input.egress.node.RcvTp;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.BfrId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class EgressNodeBuilder
implements Builder<EgressNode> {
    private BfrId _egressBfrId;
    private EgressNodeKey _key;
    private String _nodeId;
    private List<RcvTp> _rcvTp;
    Map<Class<? extends Augmentation<EgressNode>>, Augmentation<EgressNode>> augmentation = Collections.emptyMap();

    public EgressNodeBuilder() {
    }

    public EgressNodeBuilder(EgressNode base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new EgressNodeKey(base.getNodeId());
            this._nodeId = base.getNodeId();
        } else {
            this._key = base.getKey();
            this._nodeId = this._key.getNodeId();
        }
        this._egressBfrId = base.getEgressBfrId();
        this._rcvTp = base.getRcvTp();
        if (base instanceof EgressNodeImpl) {
            EgressNodeImpl impl = (EgressNodeImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<EgressNode>>, Augmentation<EgressNode>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<EgressNode>>, Augmentation<EgressNode>>(casted.augmentations());
        }
    }

    public BfrId getEgressBfrId() {
        return this._egressBfrId;
    }

    public EgressNodeKey getKey() {
        return this._key;
    }

    public String getNodeId() {
        return this._nodeId;
    }

    public List<RcvTp> getRcvTp() {
        return this._rcvTp;
    }

    public <E extends Augmentation<EgressNode>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public EgressNodeBuilder setEgressBfrId(BfrId value) {
        this._egressBfrId = value;
        return this;
    }

    public EgressNodeBuilder setKey(EgressNodeKey value) {
        this._key = value;
        return this;
    }

    public EgressNodeBuilder setNodeId(String value) {
        this._nodeId = value;
        return this;
    }

    public EgressNodeBuilder setRcvTp(List<RcvTp> value) {
        this._rcvTp = value;
        return this;
    }

    public EgressNodeBuilder addAugmentation(Class<? extends Augmentation<EgressNode>> augmentationType, Augmentation<EgressNode> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<EgressNode>>, Augmentation<EgressNode>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public EgressNodeBuilder removeAugmentation(Class<? extends Augmentation<EgressNode>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public EgressNode build() {
        return new EgressNodeImpl(this);
    }

    private static final class EgressNodeImpl
    implements EgressNode {
        private final BfrId _egressBfrId;
        private final EgressNodeKey _key;
        private final String _nodeId;
        private final List<RcvTp> _rcvTp;
        private Map<Class<? extends Augmentation<EgressNode>>, Augmentation<EgressNode>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<EgressNode> getImplementedInterface() {
            return EgressNode.class;
        }

        private EgressNodeImpl(EgressNodeBuilder base) {
            if (base.getKey() == null) {
                this._key = new EgressNodeKey(base.getNodeId());
                this._nodeId = base.getNodeId();
            } else {
                this._key = base.getKey();
                this._nodeId = this._key.getNodeId();
            }
            this._egressBfrId = base.getEgressBfrId();
            this._rcvTp = base.getRcvTp();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<EgressNode>>, Augmentation<EgressNode>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<EgressNode>>, Augmentation<EgressNode>>(base.augmentation);
                }
            }
        }

        @Override
        public BfrId getEgressBfrId() {
            return this._egressBfrId;
        }

        @Override
        public EgressNodeKey getKey() {
            return this._key;
        }

        @Override
        public String getNodeId() {
            return this._nodeId;
        }

        @Override
        public List<RcvTp> getRcvTp() {
            return this._rcvTp;
        }

        public <E extends Augmentation<EgressNode>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._egressBfrId);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._nodeId);
            result = 31 * result + Objects.hashCode(this._rcvTp);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!EgressNode.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            EgressNode other = (EgressNode)obj;
            if (!Objects.equals(this._egressBfrId, other.getEgressBfrId())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._nodeId, other.getNodeId())) {
                return false;
            }
            if (!Objects.equals(this._rcvTp, other.getRcvTp())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                EgressNodeImpl otherImpl = (EgressNodeImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<EgressNode>>, Augmentation<EgressNode>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "EgressNode [";
            StringBuilder builder = new StringBuilder(name);
            if (this._egressBfrId != null) {
                builder.append("_egressBfrId=");
                builder.append(this._egressBfrId);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._nodeId != null) {
                builder.append("_nodeId=");
                builder.append(this._nodeId);
                builder.append(", ");
            }
            if (this._rcvTp != null) {
                builder.append("_rcvTp=");
                builder.append(this._rcvTp);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

