/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.CheckChannelInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class CheckChannelInputBuilder
implements Builder<CheckChannelInput> {
    private String _channelName;
    private String _nodeName;
    Map<Class<? extends Augmentation<CheckChannelInput>>, Augmentation<CheckChannelInput>> augmentation = Collections.emptyMap();

    public CheckChannelInputBuilder() {
    }

    public CheckChannelInputBuilder(CheckChannelInput base) {
        AugmentationHolder casted;
        this._channelName = base.getChannelName();
        this._nodeName = base.getNodeName();
        if (base instanceof CheckChannelInputImpl) {
            CheckChannelInputImpl impl = (CheckChannelInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<CheckChannelInput>>, Augmentation<CheckChannelInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<CheckChannelInput>>, Augmentation<CheckChannelInput>>(casted.augmentations());
        }
    }

    public String getChannelName() {
        return this._channelName;
    }

    public String getNodeName() {
        return this._nodeName;
    }

    public <E extends Augmentation<CheckChannelInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public CheckChannelInputBuilder setChannelName(String value) {
        this._channelName = value;
        return this;
    }

    public CheckChannelInputBuilder setNodeName(String value) {
        this._nodeName = value;
        return this;
    }

    public CheckChannelInputBuilder addAugmentation(Class<? extends Augmentation<CheckChannelInput>> augmentationType, Augmentation<CheckChannelInput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<CheckChannelInput>>, Augmentation<CheckChannelInput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public CheckChannelInputBuilder removeAugmentation(Class<? extends Augmentation<CheckChannelInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public CheckChannelInput build() {
        return new CheckChannelInputImpl(this);
    }

    private static final class CheckChannelInputImpl
    implements CheckChannelInput {
        private final String _channelName;
        private final String _nodeName;
        private Map<Class<? extends Augmentation<CheckChannelInput>>, Augmentation<CheckChannelInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<CheckChannelInput> getImplementedInterface() {
            return CheckChannelInput.class;
        }

        private CheckChannelInputImpl(CheckChannelInputBuilder base) {
            this._channelName = base.getChannelName();
            this._nodeName = base.getNodeName();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<CheckChannelInput>>, Augmentation<CheckChannelInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<CheckChannelInput>>, Augmentation<CheckChannelInput>>(base.augmentation);
                }
            }
        }

        @Override
        public String getChannelName() {
            return this._channelName;
        }

        @Override
        public String getNodeName() {
            return this._nodeName;
        }

        public <E extends Augmentation<CheckChannelInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._channelName);
            result = 31 * result + Objects.hashCode(this._nodeName);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!CheckChannelInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            CheckChannelInput other = (CheckChannelInput)obj;
            if (!Objects.equals(this._channelName, other.getChannelName())) {
                return false;
            }
            if (!Objects.equals(this._nodeName, other.getNodeName())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                CheckChannelInputImpl otherImpl = (CheckChannelInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<CheckChannelInput>>, Augmentation<CheckChannelInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "CheckChannelInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._channelName != null) {
                builder.append("_channelName=");
                builder.append(this._channelName);
                builder.append(", ");
            }
            if (this._nodeName != null) {
                builder.append("_nodeName=");
                builder.append(this._nodeName);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

