/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.channel.impl;

import org.opendaylight.channel.impl.ChannelImpl;
import org.opendaylight.channel.util.ChannelDBContext;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sal.binding.api.RpcProviderRegistry;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.BierChannelApiService;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelProvider.class);
    private final DataBroker dataBroker;
    private final RpcProviderRegistry rpcRegistry;
    private BindingAwareBroker.RpcRegistration<BierChannelApiService> channelService;
    private ChannelImpl channelImpl;

    public ChannelProvider(DataBroker dataBroker, RpcProviderRegistry rpcRegistry) {
        this.dataBroker = dataBroker;
        this.rpcRegistry = rpcRegistry;
    }

    public void init() {
        LOG.info("ChannelProvider Session Initiated");
        ChannelDBContext context = new ChannelDBContext(this.dataBroker);
        this.channelImpl = new ChannelImpl(context);
        this.channelService = this.rpcRegistry.addRpcImplementation(BierChannelApiService.class, (RpcService)this.channelImpl);
        this.channelImpl.start();
    }

    public void close() {
        LOG.info("ChannelProvider Closed");
        if (this.channelService != null) {
            this.channelService.close();
        }
    }
}

