/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.channel.impl;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.opendaylight.channel.check.AddChannelInputCheck;
import org.opendaylight.channel.check.CheckResult;
import org.opendaylight.channel.check.DeployChannelInputCheck;
import org.opendaylight.channel.check.ModifyChannelInputCheck;
import org.opendaylight.channel.check.RemoveChannelInputCheck;
import org.opendaylight.channel.util.ChannelDBContext;
import org.opendaylight.channel.util.ChannelDBUtil;
import org.opendaylight.channel.util.RpcReturnUtil;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.AddChannelInput;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.AddChannelOutput;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.AddChannelOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.BierChannelApiService;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.DeployChannelInput;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.DeployChannelOutput;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.DeployChannelOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.GetChannelInput;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.GetChannelOutput;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.GetChannelOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.ModifyChannelInput;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.ModifyChannelOutput;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.ModifyChannelOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.QueryChannelInput;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.QueryChannelOutput;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.QueryChannelOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.QueryChannelWithPortInput;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.QueryChannelWithPortOutput;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.QueryChannelWithPortOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.RemoveChannelInput;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.RemoveChannelOutput;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.RemoveChannelOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.get.channel.output.ChannelName;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.get.channel.output.ChannelNameBuilder;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.query.channel.output.Channel;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.query.channel.output.ChannelBuilder;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.query.channel.output.channel.EgressNodeBuilder;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.query.channel.output.channel.egress.node.RcvTpBuilder;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.query.channel.with.port.output.QueryChannel;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.query.channel.with.port.output.QueryChannelBuilder;
import org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.BierChannel;
import org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.channel.EgressNode;
import org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.channel.egress.node.RcvTp;
import org.opendaylight.yang.gen.v1.urn.bier.common.rev161102.configure.result.ConfigureResult;
import org.opendaylight.yang.gen.v1.urn.bier.common.rev161102.configure.result.ConfigureResultBuilder;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelImpl
implements BierChannelApiService {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelImpl.class);
    private ChannelDBUtil channelDBUtil = ChannelDBUtil.getInstance();

    ChannelImpl(ChannelDBContext context) {
        this.channelDBUtil.setContext(context);
    }

    public Future<RpcResult<GetChannelOutput>> getChannel(GetChannelInput input) {
        LOG.info("Channel:get-channel {}", (Object)input);
        GetChannelOutputBuilder output = new GetChannelOutputBuilder();
        if (input == null) {
            return RpcReturnUtil.returnErr("input is null!");
        }
        List<String> channels = this.channelDBUtil.getChannels(input.getTopologyId());
        output.setChannelName(this.buildOutputChannelName(channels));
        return RpcReturnUtil.returnRpcResult(output.build());
    }

    private List<ChannelName> buildOutputChannelName(List<String> channels) {
        ArrayList<ChannelName> channelNameList = new ArrayList<ChannelName>();
        for (String channelName : channels) {
            channelNameList.add(new ChannelNameBuilder().setName(channelName).build());
        }
        return channelNameList;
    }

    public Future<RpcResult<ModifyChannelOutput>> modifyChannel(ModifyChannelInput input) {
        LOG.info("Channel:modify-channel {}", (Object)input);
        ModifyChannelOutputBuilder output = new ModifyChannelOutputBuilder();
        ModifyChannelInputCheck modifyCheck = new ModifyChannelInputCheck(input);
        CheckResult checkInputResult = modifyCheck.check();
        if (checkInputResult.isInputIllegal()) {
            output.setConfigureResult(this.buildConfigResult(ConfigureResult.Result.FAILURE, checkInputResult.getErrorCause()));
            return RpcReturnUtil.returnRpcResult(output.build());
        }
        if (!this.channelDBUtil.modifyChannelToDB(input)) {
            output.setConfigureResult(this.buildConfigResult(ConfigureResult.Result.FAILURE, "modify Channel to DB fail!"));
            return RpcReturnUtil.returnRpcResult(output.build());
        }
        output.setConfigureResult(this.buildConfigResult(ConfigureResult.Result.SUCCESS, ""));
        return RpcReturnUtil.returnRpcResult(output.build());
    }

    public Future<RpcResult<QueryChannelWithPortOutput>> queryChannelWithPort(QueryChannelWithPortInput input) {
        List channels;
        if (input == null || input.getDomainId() == null || input.getSubDomainId() == null || input.getNodeId() == null || input.getTpId() == null) {
            return RpcReturnUtil.returnErr("input is null, or domain, sub-domain, node-id, tp-id is null!");
        }
        Optional<BierChannel> bierChannel = this.channelDBUtil.readBierChannel("example-linkstate-topology");
        ArrayList<QueryChannel> outputChannels = new ArrayList<QueryChannel>();
        if (bierChannel != null && bierChannel.isPresent() && !(channels = ((BierChannel)bierChannel.get()).getChannel()).isEmpty()) {
            for (org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.Channel channel : channels) {
                if (!this.channelDBUtil.hasChannelDeplyed(channel.getName(), null)) continue;
                this.findTpFromChannel(input, channel, outputChannels);
            }
        }
        QueryChannelWithPortOutput output = new QueryChannelWithPortOutputBuilder().setQueryChannel(outputChannels).build();
        return RpcReturnUtil.returnRpcResult(output);
    }

    private void findTpFromChannel(QueryChannelWithPortInput input, org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.Channel channel, List<QueryChannel> outputChannels) {
        if (channel.getDomainId().equals((Object)input.getDomainId()) && channel.getSubDomainId().equals((Object)input.getSubDomainId())) {
            if (this.isSrcTp(input, channel)) {
                this.addChannelInfo(channel, outputChannels, false);
            } else {
                for (EgressNode egressNode : channel.getEgressNode()) {
                    if (!this.isRcvTp(input, egressNode)) continue;
                    this.addChannelInfo(channel, outputChannels, true);
                    break;
                }
            }
        }
    }

    private boolean isRcvTp(QueryChannelWithPortInput input, EgressNode egressNode) {
        return egressNode.getNodeId().equals(input.getNodeId()) && this.isTpInRcvTpList(input.getTpId(), egressNode.getRcvTp());
    }

    private boolean isTpInRcvTpList(String tpId, List<RcvTp> rcvTps) {
        if (rcvTps != null) {
            for (RcvTp rcvTp : rcvTps) {
                if (!rcvTp.getTp().equals(tpId)) continue;
                return true;
            }
        }
        return false;
    }

    private void addChannelInfo(org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.Channel channel, List<QueryChannel> outputChannels, boolean isRcvTp) {
        outputChannels.add(new QueryChannelBuilder().setChannelName(channel.getName()).setBfir(channel.getIngressNode()).setIsRcvTp(Boolean.valueOf(isRcvTp)).build());
    }

    private boolean isSrcTp(QueryChannelWithPortInput input, org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.Channel channel) {
        return channel.getIngressNode().equals(input.getNodeId()) && channel.getSrcTp().equals(input.getTpId());
    }

    public ConfigureResult buildConfigResult(ConfigureResult.Result result, String errorMsg) {
        return new ConfigureResultBuilder().setResult(result).setErrorCause(errorMsg).build();
    }

    public Future<RpcResult<DeployChannelOutput>> deployChannel(DeployChannelInput input) {
        LOG.info("Channel:deploy-channel {}", (Object)input);
        DeployChannelInputCheck deployCheck = new DeployChannelInputCheck(input);
        DeployChannelOutputBuilder output = new DeployChannelOutputBuilder();
        CheckResult checkInputResult = deployCheck.check();
        if (checkInputResult.isInputIllegal()) {
            output.setConfigureResult(this.buildConfigResult(ConfigureResult.Result.FAILURE, checkInputResult.getErrorCause()));
            return RpcReturnUtil.returnRpcResult(output.build());
        }
        if (!this.channelDBUtil.writeDeployChannelToDB(input)) {
            output.setConfigureResult(this.buildConfigResult(ConfigureResult.Result.FAILURE, "Write Deploy-Channel to DB fail!"));
            return RpcReturnUtil.returnRpcResult(output.build());
        }
        output.setConfigureResult(this.buildConfigResult(ConfigureResult.Result.SUCCESS, ""));
        return RpcReturnUtil.returnRpcResult(output.build());
    }

    public Future<RpcResult<RemoveChannelOutput>> removeChannel(RemoveChannelInput input) {
        LOG.info("Channel:remove-channel {}", (Object)input);
        RemoveChannelOutputBuilder output = new RemoveChannelOutputBuilder();
        RemoveChannelInputCheck removeCheck = new RemoveChannelInputCheck(input);
        CheckResult checkInputResult = removeCheck.check();
        if (checkInputResult.isInputIllegal()) {
            output.setConfigureResult(this.buildConfigResult(ConfigureResult.Result.FAILURE, checkInputResult.getErrorCause()));
            return RpcReturnUtil.returnRpcResult(output.build());
        }
        if (!this.channelDBUtil.deleteChannelFromDB(input)) {
            output.setConfigureResult(this.buildConfigResult(ConfigureResult.Result.FAILURE, "Delete Channel from DB fail!"));
            return RpcReturnUtil.returnRpcResult(output.build());
        }
        output.setConfigureResult(this.buildConfigResult(ConfigureResult.Result.SUCCESS, ""));
        return RpcReturnUtil.returnRpcResult(output.build());
    }

    public Future<RpcResult<QueryChannelOutput>> queryChannel(QueryChannelInput input) {
        LOG.info("Channel:Query-channel {}", (Object)input);
        QueryChannelOutputBuilder output = new QueryChannelOutputBuilder();
        if (input == null || input.getChannelName() == null || input.getChannelName().isEmpty()) {
            return RpcReturnUtil.returnErr("input or channel-name is null!");
        }
        List<org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.Channel> channels = this.channelDBUtil.queryChannels(input);
        output.setChannel(this.buildOutputChannels(channels));
        return RpcReturnUtil.returnRpcResult(output.build());
    }

    private List<Channel> buildOutputChannels(List<org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.Channel> channels) {
        ArrayList<Channel> channelList = new ArrayList<Channel>();
        for (org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.Channel channel : channels) {
            ChannelBuilder channelBuilder = new ChannelBuilder((org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.Channel)channel);
            channelBuilder.setIngressNode(channel.getIngressNode());
            channelBuilder.setSrcTp(channel.getSrcTp());
            channelBuilder.setBierForwardingType(channel.getBierForwardingType());
            channelBuilder.setEgressNode(this.buildEgressNodes(channel.getEgressNode()));
            channelList.add(channelBuilder.build());
        }
        return channelList;
    }

    private List<org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.query.channel.output.channel.EgressNode> buildEgressNodes(List<EgressNode> egressNode) {
        ArrayList<org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.query.channel.output.channel.EgressNode> egressNodeList = new ArrayList<org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.query.channel.output.channel.EgressNode>();
        if (egressNode != null && !egressNode.isEmpty()) {
            for (EgressNode node : egressNode) {
                ArrayList<org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.query.channel.output.channel.egress.node.RcvTp> rcvTpList = new ArrayList<org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.query.channel.output.channel.egress.node.RcvTp>();
                if (node.getRcvTp() != null) {
                    for (RcvTp rcvTp : node.getRcvTp()) {
                        rcvTpList.add(new RcvTpBuilder().setTp(rcvTp.getTp()).build());
                    }
                }
                egressNodeList.add(new EgressNodeBuilder().setNodeId(node.getNodeId()).setRcvTp(rcvTpList.isEmpty() ? null : rcvTpList).build());
            }
        }
        return egressNodeList;
    }

    public Future<RpcResult<AddChannelOutput>> addChannel(AddChannelInput input) {
        LOG.info("Channel:add-channel {}", (Object)input);
        AddChannelOutputBuilder output = new AddChannelOutputBuilder();
        AddChannelInputCheck addCheck = new AddChannelInputCheck(input);
        CheckResult checkInputResult = addCheck.check();
        if (checkInputResult.isInputIllegal()) {
            output.setConfigureResult(this.buildConfigResult(ConfigureResult.Result.FAILURE, checkInputResult.getErrorCause()));
            return RpcReturnUtil.returnRpcResult(output.build());
        }
        if (!this.channelDBUtil.writeChannelToDB(input)) {
            output.setConfigureResult(this.buildConfigResult(ConfigureResult.Result.FAILURE, "Write Channel to DB fail!"));
            return RpcReturnUtil.returnRpcResult(output.build());
        }
        output.setConfigureResult(this.buildConfigResult(ConfigureResult.Result.SUCCESS, ""));
        return RpcReturnUtil.returnRpcResult(output.build());
    }

    public void start() {
        this.channelDBUtil.initDB();
    }
}

