/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.channel.check;

import com.google.common.base.Preconditions;
import org.opendaylight.channel.check.ChannelInputCheck;
import org.opendaylight.channel.check.CheckResult;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.RemoveChannelInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveChannelInputCheck
extends ChannelInputCheck {
    private RemoveChannelInput removeChannelInput;
    private static final Logger LOG = LoggerFactory.getLogger(RemoveChannelInputCheck.class);

    public RemoveChannelInputCheck(RemoveChannelInput input) {
        this.removeChannelInput = input;
    }

    @Override
    public CheckResult check() {
        return this.checkParam();
    }

    private CheckResult checkParam() {
        return this.checkInputNull(this.removeChannelInput);
    }

    private CheckResult checkInputNull(RemoveChannelInput input) {
        try {
            Preconditions.checkNotNull((Object)input, (Object)"Input is null!");
            Preconditions.checkNotNull((Object)input.getChannelName(), (Object)"channel-name is null!");
        }
        catch (NullPointerException e) {
            LOG.warn("NullPointerException: {}", (Throwable)e);
            return new CheckResult(true, e.getMessage());
        }
        return new CheckResult(false, "");
    }
}

